/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.rpc;

import java.io.IOException;
import org.apache.crail.CrailNodeType;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.metadata.FileName;
import org.apache.crail.rpc.RpcCreateFile;
import org.apache.crail.rpc.RpcDeleteFile;
import org.apache.crail.rpc.RpcFuture;
import org.apache.crail.rpc.RpcGetBlock;
import org.apache.crail.rpc.RpcGetDataNode;
import org.apache.crail.rpc.RpcGetFile;
import org.apache.crail.rpc.RpcGetLocation;
import org.apache.crail.rpc.RpcPing;
import org.apache.crail.rpc.RpcRenameFile;
import org.apache.crail.rpc.RpcVoid;

public interface RpcConnection {
    public RpcFuture<RpcCreateFile> createFile(FileName var1, CrailNodeType var2, int var3, int var4, boolean var5) throws IOException;

    public RpcFuture<RpcGetFile> getFile(FileName var1, boolean var2) throws IOException;

    public RpcFuture<RpcVoid> setFile(FileInfo var1, boolean var2) throws IOException;

    public RpcFuture<RpcDeleteFile> removeFile(FileName var1, boolean var2) throws IOException;

    public RpcFuture<RpcRenameFile> renameFile(FileName var1, FileName var2) throws IOException;

    public RpcFuture<RpcGetBlock> getBlock(long var1, long var3, long var5, long var7) throws IOException;

    public RpcFuture<RpcGetLocation> getLocation(FileName var1, long var2) throws IOException;

    public RpcFuture<RpcVoid> setBlock(BlockInfo var1) throws Exception;

    public RpcFuture<RpcGetDataNode> getDataNode(DataNodeInfo var1) throws Exception;

    public RpcFuture<RpcVoid> dumpNameNode() throws Exception;

    public RpcFuture<RpcPing> pingNameNode() throws Exception;

    public void close() throws Exception;

    public static RpcConnection createInstance(String name) throws Exception {
        Class<?> nodeClass = Class.forName(name);
        if (RpcConnection.class.isAssignableFrom(nodeClass)) {
            Class<?> rpcClass = nodeClass;
            RpcConnection rpcInstance = (RpcConnection)rpcClass.newInstance();
            return rpcInstance;
        }
        throw new Exception("Cannot instantiate RPC client of type " + name);
    }
}

