/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.metadata;

import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailNodeType;
import org.apache.crail.conf.CrailConstants;

public class FileInfo {
    public static final int CSIZE = 44;
    public static final long ENUMERABLE = -1L;
    public static final long NOT_ENUMERABLE = -2L;
    private long fd;
    protected AtomicLong capacity;
    private CrailNodeType type;
    private long dirOffset;
    private long token;
    private long modificationTime;

    public FileInfo() {
        this(-1L, CrailNodeType.DATAFILE, true);
    }

    protected FileInfo(long fd, CrailNodeType type, boolean enumerable) {
        this.fd = fd;
        this.type = type;
        this.dirOffset = enumerable ? -1L : -2L;
        this.capacity = new AtomicLong(0L);
        this.token = 0L;
        this.modificationTime = 0L;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fd = fileInfo.getFd();
        this.type = fileInfo.getType();
        this.dirOffset = fileInfo.getDirOffset();
        this.capacity.set(fileInfo.getCapacity());
        this.token = fileInfo.getToken();
        this.modificationTime = fileInfo.getModificationTime();
    }

    public int write(ByteBuffer buffer, boolean shipToken) {
        buffer.putLong(this.fd);
        buffer.putLong(this.capacity.get());
        buffer.putInt(this.type.getLabel());
        buffer.putLong(this.dirOffset);
        if (shipToken) {
            buffer.putLong(this.token);
        } else {
            buffer.putLong(0L);
        }
        buffer.putLong(this.modificationTime);
        return 44;
    }

    public void update(ByteBuffer buffer) throws UnknownHostException {
        this.fd = buffer.getLong();
        this.capacity.set(buffer.getLong());
        this.type = CrailNodeType.parse(buffer.getInt());
        this.dirOffset = buffer.getLong();
        this.token = buffer.getLong();
        this.modificationTime = buffer.getLong();
    }

    public long getCapacity() {
        return this.capacity.get();
    }

    public long setCapacity(long newcapacity) {
        long oldcapacity = this.capacity.get();
        if (newcapacity > oldcapacity) {
            this.capacity.compareAndSet(oldcapacity, newcapacity);
            this.setModificationTime(System.currentTimeMillis());
        }
        return this.capacity.get();
    }

    public long incCapacity(int delta) {
        long newcapacity = this.capacity.addAndGet(delta);
        this.setModificationTime(System.currentTimeMillis());
        return newcapacity;
    }

    public void resetCapacity() {
        this.capacity.set(0L);
    }

    public long getToken() {
        return this.token;
    }

    public void resetToken() {
        this.token = 0L;
    }

    public void updateToken() {
        if (!this.type.isDirectory()) {
            this.token = System.nanoTime() + TimeUnit.SECONDS.toNanos(CrailConstants.TOKEN_EXPIRATION);
        }
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public long getDirOffset() {
        return this.dirOffset;
    }

    protected void setDirOffset(long dirOffset) {
        this.dirOffset = dirOffset;
    }

    public long getFd() {
        return this.fd;
    }

    public String toString() {
        return "fd " + this.fd + ", capacity " + this.capacity + ", type " + this.type.getLabel() + ", dirOffset " + this.dirOffset + ", token " + this.token;
    }

    public CrailNodeType getType() {
        return this.type;
    }

    public boolean tokenFree() {
        return System.nanoTime() > this.token;
    }

    public void setToken(long value) {
        this.token = value;
    }

    public boolean isEnumerable() {
        return this.dirOffset > -2L;
    }
}

