/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.metadata;

import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.crail.metadata.DataNodeInfo;

public class BlockInfo {
    public static int CSIZE = 44;
    protected DataNodeInfo dnInfo;
    protected long lba;
    protected long addr;
    protected int length;
    protected int lkey;

    public BlockInfo() {
        this.dnInfo = new DataNodeInfo();
        this.lba = 0L;
        this.addr = 0L;
        this.length = 0;
        this.lkey = 0;
    }

    public BlockInfo(DataNodeInfo dnInfo, long lba, long addr, int length, int lkey) {
        this.dnInfo = dnInfo;
        this.lba = lba;
        this.addr = addr;
        this.length = length;
        this.lkey = lkey;
    }

    public void setBlockInfo(BlockInfo blockInfo) {
        this.dnInfo.setDataNodeInfo(blockInfo.getDnInfo());
        this.lba = blockInfo.getLba();
        this.addr = blockInfo.getAddr();
        this.length = blockInfo.getLength();
        this.lkey = blockInfo.getLkey();
    }

    public int write(ByteBuffer buffer) {
        this.getDnInfo().write(buffer);
        buffer.putLong(this.getLba());
        buffer.putLong(this.getAddr());
        buffer.putInt(this.getLength());
        buffer.putInt(this.getLkey());
        return CSIZE;
    }

    public void update(ByteBuffer buffer) throws UnknownHostException {
        this.dnInfo.update(buffer);
        this.lba = buffer.getLong();
        this.addr = buffer.getLong();
        this.length = buffer.getInt();
        this.lkey = buffer.getInt();
    }

    public long getLba() {
        return this.lba;
    }

    public long getAddr() {
        return this.addr;
    }

    public int getLength() {
        return this.length;
    }

    public int getLkey() {
        return this.lkey;
    }

    public DataNodeInfo getDnInfo() {
        return this.dnInfo;
    }

    public String toString() {
        return "BlockInfo [dnInfo=" + this.dnInfo + ", lba=" + this.lba + ", addr=" + this.addr + ", length=" + this.length + ", lkey=" + this.lkey + "]";
    }
}

