/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.memory;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.crail.CrailBuffer;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.memory.BufferCache;
import org.apache.crail.memory.OffHeapBuffer;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class MappedBufferCache
extends BufferCache {
    private static final Logger LOG = CrailUtils.getLogger();
    private String id;
    private String directory;
    private File dir;
    private long allocationCount = CrailConstants.CACHE_LIMIT / CrailConstants.REGION_SIZE;
    private long bufferCount;
    private long currentRegion;

    public MappedBufferCache() throws IOException {
        long _bufferSize = CrailConstants.BUFFER_SIZE;
        this.bufferCount = CrailConstants.REGION_SIZE / _bufferSize;
        this.currentRegion = 0L;
        LOG.info("buffer cache, allocationCount " + this.allocationCount + ", bufferCount " + this.bufferCount);
        if (this.allocationCount > 0L) {
            this.id = "" + System.currentTimeMillis();
            this.directory = CrailUtils.getCacheDirectory(this.id);
            this.dir = new File(this.directory);
            try {
                if (this.dir.exists()) {
                    throw new IOException("A cache directory with the same id " + this.id + " already exists!");
                }
                if (!this.dir.mkdirs()) {
                    throw new IOException("Cannot create cache directory [crail.cachepath] set to path " + this.directory + ", check if crail.cachepath exists and has write permissions");
                }
                for (File child : this.dir.listFiles()) {
                    child.delete();
                }
            }
            catch (SecurityException e) {
                throw new IOException("Security exception when trying to access " + this.directory + ", please check the directory permissions", e);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.allocationCount > 0L && this.dir.exists()) {
            for (File child : this.dir.listFiles()) {
                child.delete();
            }
            this.dir.delete();
        }
        LOG.info("mapped client cache closed");
    }

    @Override
    public CrailBuffer allocateRegion() throws IOException {
        if (this.currentRegion >= this.allocationCount) {
            return null;
        }
        String path = this.directory + "/" + this.currentRegion++;
        RandomAccessFile randomFile = new RandomAccessFile(path, "rw");
        randomFile.setLength(CrailConstants.REGION_SIZE);
        FileChannel channel = randomFile.getChannel();
        MappedByteBuffer _mappedBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, CrailConstants.REGION_SIZE);
        OffHeapBuffer mappedBuffer = OffHeapBuffer.wrap(_mappedBuffer);
        randomFile.close();
        channel.close();
        CrailBuffer firstBuffer = this.slice(mappedBuffer, 0);
        int j = 1;
        while ((long)j < this.bufferCount) {
            int position = j * CrailConstants.BUFFER_SIZE;
            CrailBuffer sliceBuffer = this.slice(mappedBuffer, position);
            this.putBufferInternal(sliceBuffer);
            ++j;
        }
        mappedBuffer.clear();
        return firstBuffer;
    }

    private CrailBuffer slice(CrailBuffer mappedBuffer, int position) {
        int limit = position + CrailConstants.BUFFER_SIZE;
        mappedBuffer.clear();
        mappedBuffer.position(position);
        mappedBuffer.limit(limit);
        CrailBuffer buffer = mappedBuffer.slice();
        return buffer;
    }
}

