/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailResult;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.CoreNode;
import org.apache.crail.core.CoreOutputStream;
import org.apache.crail.core.DirectoryRecord;

public class DirectoryOutputStream {
    private CoreOutputStream stream;
    private CrailBuffer internalBuf;
    private CoreDataStore fs;
    private boolean open;

    public DirectoryOutputStream(CoreOutputStream stream) throws Exception {
        this.fs = ((CoreNode)stream.getFile()).getFileSystem();
        this.stream = stream;
        this.internalBuf = this.fs.allocateBuffer();
        this.open = true;
    }

    Future<CrailResult> writeRecord(DirectoryRecord record, long offset) throws Exception {
        if (!this.open) {
            throw new IOException("stream closed");
        }
        this.internalBuf.clear();
        record.write(this.internalBuf);
        this.internalBuf.flip();
        this.stream.seek(offset);
        Future<CrailResult> future = this.stream.write(this.internalBuf);
        return future;
    }

    public void close() throws IOException {
        try {
            if (!this.open) {
                return;
            }
            this.stream.close();
            this.fs.freeBuffer(this.internalBuf);
            this.internalBuf = null;
            this.open = false;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public int getBufCapacity() {
        return this.internalBuf.capacity();
    }

    public int getBufPosition() {
        return this.internalBuf.position();
    }

    public int getBufLimit() {
        return this.internalBuf.limit();
    }
}

