/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.util.concurrent.Future;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailNodeType;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.CoreEarlyFile;
import org.apache.crail.core.CoreMetaDataOperation;
import org.apache.crail.rpc.RpcCreateFile;

class CreateNodeFuture
extends CoreMetaDataOperation<RpcCreateFile, CrailNode> {
    private CoreDataStore fs;
    private String path;
    private CrailNodeType type;

    public CreateNodeFuture(CoreDataStore fs, String path, CrailNodeType type, Future<RpcCreateFile> fileRes) {
        super(fileRes);
        this.fs = fs;
        this.path = path;
        this.type = type;
    }

    @Override
    CrailNode process(RpcCreateFile response) throws Exception {
        return this.fs._createNode(this.path, this.type, response);
    }

    @Override
    public CrailNode early() throws Exception {
        switch (this.type) {
            case DATAFILE: {
                return new CoreEarlyFile(this.fs, this.path, this.type, this);
            }
            case DIRECTORY: 
            case MULTIFILE: {
                return null;
            }
        }
        return (CrailNode)super.early();
    }
}

