/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.io.IOException;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.utils.CrailUtils;

public class CoreSubOperation {
    private long fd;
    private long fileOffset;
    private int bufferPosition;
    private int len;
    private long blockOffset;
    private long blockStart;
    private long key;

    public CoreSubOperation(long fd, long fileOffset, int bufferPosition, int writeLen) throws IOException {
        this.fd = fd;
        this.fileOffset = fileOffset;
        this.bufferPosition = bufferPosition;
        this.len = writeLen;
        this.blockOffset = fileOffset % CrailConstants.BLOCK_SIZE;
        this.key = this.blockStart = CrailUtils.blockStartAddress(fileOffset);
    }

    public long getFd() {
        return this.fd;
    }

    public long getBlockOffset() {
        return this.blockOffset;
    }

    public long getBlockStart() {
        return this.blockStart;
    }

    public int getBufferPosition() {
        return this.bufferPosition;
    }

    public int getLen() {
        return this.len;
    }

    public String toString() {
        return "fd " + this.fd + ", fileOffset " + this.fileOffset + ", blockOffset " + this.blockOffset + ", len " + this.len + ", blockStart " + this.blockStart;
    }

    public long key() {
        return this.key;
    }

    public static long createKey(long fd, long fileOffset) {
        long offset = CrailUtils.blockStartAddress(fileOffset);
        return offset;
    }
}

