/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailStatistics;

public class CoreStreamStatistics
implements CrailStatistics.StatisticsProvider {
    private AtomicLong open = new AtomicLong(0L);
    private AtomicLong openInput = new AtomicLong(0L);
    private AtomicLong openOutput = new AtomicLong(0L);
    private AtomicLong openInputDir = new AtomicLong(0L);
    private AtomicLong openOutputDir = new AtomicLong(0L);
    private AtomicLong close = new AtomicLong(0L);
    private AtomicLong closeInput = new AtomicLong(0L);
    private AtomicLong closeOutput = new AtomicLong(0L);
    private AtomicLong closeInputDir = new AtomicLong(0L);
    private AtomicLong closeOutputDir = new AtomicLong(0L);
    private AtomicLong currentInput = new AtomicLong(0L);
    private AtomicLong currentOutput = new AtomicLong(0L);
    private AtomicLong maxInput = new AtomicLong(0L);
    private AtomicLong maxOutput = new AtomicLong(0L);

    @Override
    public String providerName() {
        return "core/streams";
    }

    @Override
    public String printStatistics() {
        return "open " + this.getOpen() + ", openInput " + this.getOpenInput() + ", openOutput " + this.getOpenOutput() + ", openInputDir " + this.getOpenInputDir() + ", openOutputDir " + this.getOpenOutputDir() + ", close " + this.getClose() + ", closeInput " + this.getCloseInput() + ", closeOutput " + this.getCloseOutput() + ", closeInputDir " + this.getCloseInputDir() + ", closeOutputDir " + this.getCloseOutputDir() + ", maxInput " + this.getMaxInput() + ", maxOutput " + this.getMaxOutput();
    }

    @Override
    public void resetStatistics() {
        this.open.set(0L);
        this.openInput.set(0L);
        this.openOutput.set(0L);
        this.openInputDir.set(0L);
        this.openOutputDir.set(0L);
        this.close.set(0L);
        this.closeInput.set(0L);
        this.closeOutput.set(0L);
        this.closeInputDir.set(0L);
        this.closeOutputDir.set(0L);
        this.currentInput.set(0L);
        this.currentOutput.set(0L);
        this.maxInput.set(0L);
        this.maxOutput.set(0L);
    }

    @Override
    public void mergeStatistics(CrailStatistics.StatisticsProvider provider) {
    }

    public void incOpen() {
        this.open.incrementAndGet();
    }

    public void incOpenInput() {
        this.openInput.incrementAndGet();
    }

    public void incOpenOutput() {
        this.openOutput.incrementAndGet();
    }

    public void incOpenInputDir() {
        this.openInputDir.incrementAndGet();
    }

    public void incOpenOutputDir() {
        this.openOutputDir.incrementAndGet();
    }

    public void incClose() {
        this.close.incrementAndGet();
    }

    public void incCloseInput() {
        this.closeInput.incrementAndGet();
    }

    public void incCloseOutput() {
        this.closeOutput.incrementAndGet();
    }

    public void incCloseInputDir() {
        this.closeInputDir.incrementAndGet();
    }

    public void incCloseOutputDir() {
        this.closeOutputDir.incrementAndGet();
    }

    public void incCurrentInput() {
        this.currentInput.incrementAndGet();
    }

    public void incCurrentOutput() {
        this.currentOutput.incrementAndGet();
    }

    public void decCurrentInput() {
        this.currentInput.decrementAndGet();
    }

    public void decCurrentOutput() {
        this.currentOutput.decrementAndGet();
    }

    public void incMaxInput() {
        this.maxInput.updateAndGet(x -> Math.max(x, this.currentInput.get()));
    }

    public void incMaxOutput() {
        this.maxOutput.updateAndGet(x -> Math.max(x, this.currentOutput.get()));
    }

    public long getOpen() {
        return this.open.get();
    }

    public long getOpenInput() {
        return this.openInput.get();
    }

    public long getOpenOutput() {
        return this.openOutput.get();
    }

    public long getOpenInputDir() {
        return this.openInputDir.get();
    }

    public long getOpenOutputDir() {
        return this.openOutputDir.get();
    }

    public long getClose() {
        return this.close.get();
    }

    public long getCloseInput() {
        return this.closeInput.get();
    }

    public long getCloseOutput() {
        return this.closeOutput.get();
    }

    public long getCloseInputDir() {
        return this.closeInputDir.get();
    }

    public long getCloseOutputDir() {
        return this.closeOutputDir.get();
    }

    public long getCurrentInput() {
        return this.currentInput.get();
    }

    public long getCurrentOutput() {
        return this.currentOutput.get();
    }

    public long getMaxInput() {
        return this.maxInput.get();
    }

    public long getMaxOutput() {
        return this.maxOutput.get();
    }
}

