/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.crail.CrailBuffer;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.core.CoreDataOperation;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.CoreIOStatistics;
import org.apache.crail.core.CoreNode;
import org.apache.crail.core.CoreSubOperation;
import org.apache.crail.core.NoOperation;
import org.apache.crail.core.SyncNodeFuture;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.rpc.RpcConnection;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.rpc.RpcFuture;
import org.apache.crail.rpc.RpcGetBlock;
import org.apache.crail.rpc.RpcVoid;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.utils.BlockCache;
import org.apache.crail.utils.BufferCheckpoint;
import org.apache.crail.utils.CrailUtils;
import org.apache.crail.utils.EndpointCache;
import org.apache.crail.utils.NextBlockCache;
import org.slf4j.Logger;

public abstract class CoreStream {
    private static final Logger LOG = CrailUtils.getLogger();
    protected CoreDataStore fs;
    protected CoreNode node;
    private EndpointCache endpointCache;
    private RpcConnection namenodeClientRpc;
    private BlockCache.FileBlockCache blockCache;
    private NextBlockCache.FileNextBlockCache nextBlockCache;
    private BufferCheckpoint bufferCheckpoint;
    private FileInfo fileInfo;
    private long position;
    private long syncedCapacity;
    private long streamId;
    private CoreIOStatistics ioStats;
    private HashMap<Integer, CoreSubOperation> blockMap;
    private LinkedList<RpcFuture<RpcGetBlock>> pendingBlocks;

    abstract StorageFuture trigger(StorageEndpoint var1, CoreSubOperation var2, CrailBuffer var3, BlockInfo var4) throws Exception;

    abstract void update(long var1);

    CoreStream(CoreNode node, long streamId, long fileOffset) throws Exception {
        this.node = node;
        this.fs = node.getFileSystem();
        this.fileInfo = node.getFileInfo();
        this.endpointCache = this.fs.getDatanodeEndpointCache();
        this.namenodeClientRpc = this.fs.getNamenodeClientRpc();
        this.blockCache = this.fs.getBlockCache(this.fileInfo.getFd());
        this.nextBlockCache = this.fs.getNextBlockCache(this.fileInfo.getFd());
        this.bufferCheckpoint = this.fs.getBufferCheckpoint();
        this.position = fileOffset;
        this.syncedCapacity = this.fileInfo.getCapacity();
        this.streamId = streamId;
        this.ioStats = new CoreIOStatistics("core");
        this.blockMap = new HashMap();
        this.pendingBlocks = new LinkedList();
    }

    final CoreDataOperation dataOperation(CrailBuffer dataBuf) throws Exception {
        CoreSubOperation subOperation;
        this.blockMap.clear();
        this.pendingBlocks.clear();
        CoreDataOperation multiOperation = new CoreDataOperation(this, dataBuf);
        while (multiOperation.remaining() > 0) {
            RpcFuture<RpcGetBlock> rpcFuture;
            long blockRemaining = this.blockRemaining();
            int opLen = CrailUtils.minFileBuf(blockRemaining, multiOperation.remaining());
            subOperation = new CoreSubOperation(this.fileInfo.getFd(), this.position, multiOperation.getCurrentBufferPosition(), opLen);
            this.ioStats.incTotalOps(opLen);
            if (this.blockCache.containsKey(subOperation.key())) {
                BlockInfo block = this.blockCache.get(subOperation.key());
                StorageFuture subFuture = this.prepareAndTrigger(subOperation, dataBuf, block);
                multiOperation.add(subFuture);
                this.ioStats.incCachedOps();
            } else if (this.nextBlockCache.containsKey(subOperation.key())) {
                rpcFuture = this.nextBlockCache.get(subOperation.key());
                this.blockMap.put(rpcFuture.getTicket(), subOperation);
                this.pendingBlocks.add(rpcFuture);
            } else {
                this.syncedCapacity = this.fileInfo.getCapacity();
                rpcFuture = this.namenodeClientRpc.getBlock(this.fileInfo.getFd(), this.fileInfo.getToken(), this.position, this.syncedCapacity);
                this.blockMap.put(rpcFuture.getTicket(), subOperation);
                this.pendingBlocks.add(rpcFuture);
            }
            this.position += (long)opLen;
            multiOperation.incProcessedLen(opLen);
        }
        RpcFuture<RpcGetBlock> rpcFuture = this.pendingBlocks.poll();
        while (rpcFuture != null) {
            if (!rpcFuture.isDone()) {
                this.ioStats.incBlockingOps();
                if (rpcFuture.isPrefetched()) {
                    this.ioStats.incPrefetchedBlockingOps();
                }
            } else {
                this.ioStats.incNonblockingOps();
                if (rpcFuture.isPrefetched()) {
                    this.ioStats.incPrefetchedNonblockingOps();
                }
            }
            RpcGetBlock getBlockRes = (RpcGetBlock)rpcFuture.get(CrailConstants.RPC_TIMEOUT, TimeUnit.MILLISECONDS);
            if (!rpcFuture.isDone()) {
                throw new IOException("rpc timeout ");
            }
            if (getBlockRes.getError() != RpcErrors.ERR_OK) {
                LOG.info("inputStream: " + RpcErrors.messages[getBlockRes.getError()]);
                throw new IOException(RpcErrors.messages[getBlockRes.getError()]);
            }
            BlockInfo block = getBlockRes.getBlockInfo();
            subOperation = this.blockMap.get(rpcFuture.getTicket());
            StorageFuture subFuture = this.prepareAndTrigger(subOperation, dataBuf, block);
            multiOperation.add(subFuture);
            this.blockCache.put(subOperation.key(), block);
            rpcFuture = this.pendingBlocks.poll();
        }
        if (!multiOperation.isProcessed()) {
            throw new IOException("Internal error, processed data != operation length");
        }
        dataBuf.limit(multiOperation.getBufferLimit());
        dataBuf.position(multiOperation.getCurrentBufferPosition());
        return multiOperation;
    }

    final void prefetchMetadata() throws Exception {
        long key = CoreSubOperation.createKey(this.fileInfo.getFd(), this.position);
        if (this.blockCache.containsKey(key)) {
            return;
        }
        if (this.nextBlockCache.containsKey(key)) {
            return;
        }
        this.syncedCapacity = this.fileInfo.getCapacity();
        RpcFuture<RpcGetBlock> nextBlock = this.namenodeClientRpc.getBlock(this.fileInfo.getFd(), this.fileInfo.getToken(), this.position, this.syncedCapacity);
        nextBlock.setPrefetched(true);
        this.nextBlockCache.put(key, nextBlock);
        this.ioStats.incPrefetchedOps();
    }

    void seek(long pos) throws IOException {
        long newOffset = Math.min(this.fileInfo.getCapacity(), Math.max(0L, pos));
        if (newOffset != pos) {
            throw new IOException("seek position out of range, pos " + pos + ", fileCapacity " + this.fileInfo.getCapacity());
        }
        this.position = newOffset;
    }

    Future<Void> sync() throws IOException {
        Future<Void> future = null;
        if (this.fileInfo.getToken() > 0L && this.syncedCapacity < this.fileInfo.getCapacity()) {
            this.syncedCapacity = this.fileInfo.getCapacity();
            future = new SyncNodeFuture((Future<RpcVoid>)this.namenodeClientRpc.setFile(this.fileInfo, false));
        } else {
            future = new NoOperation();
        }
        return future;
    }

    void updateIOStats() {
        this.ioStats.setCapacity(this.fileInfo.getCapacity());
    }

    long getStreamId() {
        return this.streamId;
    }

    public long position() {
        return this.position;
    }

    CoreIOStatistics getCoreStatistics() {
        return this.ioStats;
    }

    public CoreNode getFile() {
        return this.node;
    }

    BufferCheckpoint getBufferCheckpoint() {
        return this.bufferCheckpoint;
    }

    void setCapacity(long currentCapacity) {
        this.fileInfo.setCapacity(currentCapacity);
    }

    private long blockRemaining() {
        long blockOffset = this.position % CrailConstants.BLOCK_SIZE;
        long blockRemaining = CrailConstants.BLOCK_SIZE - blockOffset;
        return blockRemaining;
    }

    private StorageFuture prepareAndTrigger(CoreSubOperation opDesc, CrailBuffer dataBuf, BlockInfo block) throws Exception {
        try {
            StorageEndpoint endpoint = this.endpointCache.getDataEndpoint(block.getDnInfo());
            dataBuf.clear();
            dataBuf.position(opDesc.getBufferPosition());
            dataBuf.limit(dataBuf.position() + opDesc.getLen());
            StorageFuture subFuture = this.trigger(endpoint, opDesc, dataBuf, block);
            this.incStats(endpoint.isLocal());
            return subFuture;
        }
        catch (IOException e) {
            LOG.info("ERROR: failed data operation");
            e.printStackTrace();
            throw e;
        }
    }

    private void incStats(boolean isLocal) {
        if (CrailConstants.STATISTICS) {
            if (isLocal) {
                this.ioStats.incLocalOps();
                if (this.fileInfo.getType().isDirectory()) {
                    this.ioStats.incLocalDirOps();
                }
            } else {
                this.ioStats.incRemoteOps();
                if (this.fileInfo.getType().isDirectory()) {
                    this.ioStats.incRemoteDirOps();
                }
            }
        }
    }
}

