/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailInputStream;
import org.apache.crail.CrailResult;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.core.CoreDataOperation;
import org.apache.crail.core.CoreNode;
import org.apache.crail.core.CoreStream;
import org.apache.crail.core.CoreSubOperation;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.utils.CrailImmediateOperation;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class CoreInputStream
extends CoreStream
implements CrailInputStream {
    private static final Logger LOG = CrailUtils.getLogger();
    private AtomicLong inFlight = new AtomicLong(0L);
    private long readHint;
    private CrailImmediateOperation noOp;
    private boolean open;

    public CoreInputStream(CoreNode file, long streamId, long readHint) throws Exception {
        super(file, streamId, 0L);
        this.readHint = Math.max(0L, Math.min(file.getCapacity(), readHint));
        this.noOp = new CrailImmediateOperation(0);
        this.open = true;
        if (CrailConstants.DEBUG) {
            LOG.info("CoreInputStream: open, path  " + file.getPath() + ", fd " + file.getFd() + ", streamId " + streamId + ", isDir " + file.getType().isDirectory() + ", readHint " + this.readHint);
        }
    }

    @Override
    public final Future<CrailResult> read(CrailBuffer dataBuf) throws Exception {
        long bufAvailable;
        if (!this.open) {
            throw new IOException("stream already closed");
        }
        if (dataBuf.remaining() <= 0) {
            return this.noOp;
        }
        if (this.position() >= ((CoreNode)this.getFile()).getCapacity()) {
            return null;
        }
        long fileAvailable = this.available();
        if (fileAvailable < (bufAvailable = (long)dataBuf.remaining())) {
            int _fileAvailable = (int)fileAvailable;
            dataBuf.limit(dataBuf.position() + _fileAvailable);
        }
        this.inFlight.incrementAndGet();
        CoreDataOperation future = this.dataOperation(dataBuf);
        if (this.position() < this.readHint) {
            this.prefetchMetadata();
        }
        if (future.isSynchronous()) {
            future.get();
        }
        return future;
    }

    @Override
    public final int available() {
        long maxint;
        long available = Math.max(0L, ((CoreNode)this.getFile()).getCapacity() - this.position());
        if (available < (maxint = Integer.MAX_VALUE)) {
            return (int)available;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final void seek(long pos) throws IOException {
        long oldPos = this.position();
        super.seek(pos);
        long newPos = this.position();
        if (oldPos != newPos) {
            this.readHint = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.open) {
            return;
        }
        if (this.inFlight.get() != 0L) {
            LOG.info("Cannot close, pending operations, opcount " + this.inFlight.get() + ", path " + ((CoreNode)this.getFile()).getPath());
            throw new IOException("Cannot close, pending operations, opcount " + this.inFlight.get());
        }
        this.updateIOStats();
        this.node.closeInputStream(this);
        this.open = false;
        if (CrailConstants.DEBUG) {
            LOG.info("CoreInputStream, close, path " + ((CoreNode)this.getFile()).getPath() + ", fd " + ((CoreNode)this.getFile()).getFd() + ", streamId " + this.getStreamId());
        }
    }

    @Override
    StorageFuture trigger(StorageEndpoint endpoint, CoreSubOperation opDesc, CrailBuffer buffer, BlockInfo block) throws Exception {
        StorageFuture future = endpoint.read(buffer, block, opDesc.getBlockOffset());
        return future;
    }

    @Override
    void update(long newCapacity) {
        this.inFlight.decrementAndGet();
    }
}

