/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.util.concurrent.Semaphore;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailInputStream;
import org.apache.crail.CrailKeyValue;
import org.apache.crail.CrailOutputStream;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.CoreNode;
import org.apache.crail.core.CoreOutputStream;
import org.apache.crail.metadata.FileInfo;

public class CoreFile
extends CoreNode
implements CrailFile,
CrailKeyValue {
    private Semaphore outputStreams = new Semaphore(1);

    public CoreFile(CoreDataStore fs, FileInfo fileInfo, String path) {
        super(fs, fileInfo, path);
    }

    @Override
    public CrailInputStream getDirectInputStream(long readHint) throws Exception {
        if (this.fileInfo.getType().isDirectory()) {
            throw new Exception("Cannot open stream for directory");
        }
        return super.getInputStream(readHint);
    }

    @Override
    public synchronized CrailOutputStream getDirectOutputStream(long writeHint) throws Exception {
        if (this.fileInfo.getType().isDirectory()) {
            throw new Exception("Cannot open stream for directory");
        }
        if (this.fileInfo.getToken() == 0L) {
            throw new Exception("File is in read mode, cannot create outputstream, fd " + this.fileInfo.getFd());
        }
        if (!this.outputStreams.tryAcquire()) {
            throw new Exception("Only one concurrent output stream per file allowed");
        }
        return super.getOutputStream(writeHint);
    }

    @Override
    public long getToken() {
        return this.fileInfo.getToken();
    }

    public boolean tokenFree() {
        return this.fileInfo.tokenFree();
    }

    @Override
    public CoreFile asFile() throws Exception {
        if (!this.getType().isDataFile()) {
            throw new Exception("file type mismatch, type " + (Object)((Object)this.getType()));
        }
        return this;
    }

    @Override
    public CoreFile asKeyValue() throws Exception {
        if (!this.getType().isKeyValue()) {
            throw new Exception("file type mismatch, type " + (Object)((Object)this.getType()));
        }
        return this;
    }

    @Override
    void closeOutputStream(CoreOutputStream stream) throws Exception {
        super.closeOutputStream(stream);
        this.outputStreams.release();
    }
}

