/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailResult;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.core.CoreStream;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.StorageResult;
import org.apache.crail.utils.BufferCheckpoint;
import org.apache.crail.utils.MultiFuture;

class CoreDataOperation
extends MultiFuture<StorageResult, CrailResult>
implements CrailResult {
    private CoreStream stream;
    private CrailBuffer buffer;
    private long fileOffset;
    private int bufferPosition;
    private int bufferLimit;
    private int operationLength;
    private BufferCheckpoint bufferCheckpoint;
    private int inProcessLen;
    private long completedLen;
    private boolean isSynchronous;

    public CoreDataOperation(CoreStream stream, CrailBuffer buffer) throws Exception {
        this.stream = stream;
        this.buffer = buffer;
        this.fileOffset = stream.position();
        this.bufferPosition = buffer.position();
        this.bufferLimit = buffer.limit();
        this.operationLength = buffer.remaining();
        this.inProcessLen = 0;
        this.completedLen = 0L;
        this.isSynchronous = false;
        if (this.operationLength > 0) {
            this.bufferCheckpoint = stream.getBufferCheckpoint();
            if (CrailConstants.DEBUG) {
                this.bufferCheckpoint.checkIn(buffer);
            }
        }
    }

    @Override
    public long getLen() {
        return this.completedLen;
    }

    void incProcessedLen(int opLen) {
        this.inProcessLen += opLen;
    }

    long getInProcessLen() {
        return this.inProcessLen;
    }

    int getBufferLimit() {
        return this.bufferLimit;
    }

    int remaining() {
        return this.operationLength - this.inProcessLen;
    }

    int getCurrentBufferPosition() {
        return this.bufferPosition + this.inProcessLen;
    }

    long getCurrentStreamPosition() {
        return this.fileOffset + (long)this.inProcessLen;
    }

    boolean isProcessed() {
        return this.inProcessLen == this.operationLength;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public synchronized void add(StorageFuture dataFuture) {
        super.add(dataFuture);
        if (dataFuture.isSynchronous()) {
            this.isSynchronous = true;
        }
    }

    @Override
    public void completeOperation() {
        super.completeOperation();
        if (this.isDone()) {
            this.stream.update(this.fileOffset + this.completedLen);
            if (CrailConstants.DEBUG) {
                this.bufferCheckpoint.checkOut(this.buffer);
            }
        }
    }

    boolean isSynchronous() {
        return this.isSynchronous;
    }

    @Override
    public void aggregate(StorageResult result) {
        this.completedLen += (long)result.getLen();
    }

    @Override
    public CrailResult getAggregate() {
        return this;
    }
}

