/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.conf;

import java.io.IOException;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class CrailConstants {
    private static final Logger LOG = CrailUtils.getLogger();
    public static final String VERSION_KEY = "crail.version";
    public static int VERSION = 3101;
    public static final String DIRECTORY_DEPTH_KEY = "crail.directorydepth";
    public static int DIRECTORY_DEPTH = 16;
    public static final String TOKEN_EXPIRATION_KEY = "crail.tokenexpiration";
    public static long TOKEN_EXPIRATION = 10L;
    public static final String BLOCK_SIZE_KEY = "crail.blocksize";
    public static long BLOCK_SIZE = 0x100000L;
    public static final String CACHE_LIMIT_KEY = "crail.cachelimit";
    public static long CACHE_LIMIT = 0x40000000L;
    public static final String CACHE_PATH_KEY = "crail.cachepath";
    public static String CACHE_PATH = "/dev/hugepages/cache";
    public static final String USER_KEY = "crail.user";
    public static String USER = "crail";
    public static final String SHADOW_REPLICATION_KEY = "crail.shadowreplication";
    public static int SHADOW_REPLICATION = 1;
    public static final String DEBUG_KEY = "crail.debug";
    public static boolean DEBUG = false;
    public static final String STATISTICS_KEY = "crail.statistics";
    public static boolean STATISTICS = true;
    public static final String RPC_TIMEOUT_KEY = "crail.rpctimeout";
    public static int RPC_TIMEOUT = 1000;
    public static final String DATA_TIMEOUT_KEY = "crail.datatimeout";
    public static int DATA_TIMEOUT = 1000;
    public static final String BUFFER_SIZE_KEY = "crail.buffersize";
    public static int BUFFER_SIZE = 0x100000;
    public static final String SLICE_SIZE_KEY = "crail.slicesize";
    public static int SLICE_SIZE = 524288;
    public static final String SINGLETON_KEY = "crail.singleton";
    public static boolean SINGLETON = true;
    public static final String REGION_SIZE_KEY = "crail.regionsize";
    public static long REGION_SIZE = 0x40000000L;
    public static final String DIRECTORY_RECORD_KEY = "crail.directoryrecord";
    public static int DIRECTORY_RECORD = 512;
    public static final String DIRECTORY_RANDOMIZE_KEY = "crail.directoryrandomize";
    public static boolean DIRECTORY_RANDOMIZE = true;
    public static final String CACHE_IMPL_KEY = "crail.cacheimpl";
    public static String CACHE_IMPL = "org.apache.crail.memory.MappedBufferCache";
    public static final String LOCATION_MAP_KEY = "crail.locationmap";
    public static String LOCATION_MAP = "";
    public static final String NAMENODE_ADDRESS_KEY = "crail.namenode.address";
    public static String NAMENODE_ADDRESS = "crail://localhost:9060";
    public static final String NAMENODE_FILEBLOCKS_KEY = "crail.namenode.fileblocks";
    public static int NAMENODE_FILEBLOCKS = 16;
    public static final String NAMENODE_BLOCKSELECTION_KEY = "crail.namenode.blockselection";
    public static String NAMENODE_BLOCKSELECTION = "roundrobin";
    public static final String NAMENODE_RPC_TYPE_KEY = "crail.namenode.rpctype";
    public static String NAMENODE_RPC_TYPE = "org.apache.crail.namenode.rpc.tcp.TcpNameNode";
    public static final String NAMENODE_RPC_SERVICE_KEY = "crail.namenode.rpcservice";
    public static String NAMENODE_RPC_SERVICE = "org.apache.crail.namenode.NameNodeService";
    public static final String NAMENODE_LOG_KEY = "crail.namenode.log";
    public static String NAMENODE_LOG = "";
    public static final String STORAGE_TYPES_KEY = "crail.storage.types";
    public static String STORAGE_TYPES = "org.apache.crail.storage.tcp.TcpStorageTier";
    public static final String STORAGE_CLASSES_KEY = "crail.storage.classes";
    public static int STORAGE_CLASSES = 1;
    public static final String STORAGE_ROOTCLASS_KEY = "crail.storage.rootclass";
    public static int STORAGE_ROOTCLASS = 0;
    public static final String STORAGE_KEEPALIVE_KEY = "crail.storage.keepalive";
    public static int STORAGE_KEEPALIVE = 2;

    public static void updateConstants(CrailConfiguration conf) {
        if (conf.get(DIRECTORY_DEPTH_KEY) != null) {
            DIRECTORY_DEPTH = Integer.parseInt(conf.get(DIRECTORY_DEPTH_KEY));
        }
        if (conf.get(TOKEN_EXPIRATION_KEY) != null) {
            TOKEN_EXPIRATION = Long.parseLong(conf.get(TOKEN_EXPIRATION_KEY));
        }
        if (conf.get(BLOCK_SIZE_KEY) != null) {
            BLOCK_SIZE = Long.parseLong(conf.get(BLOCK_SIZE_KEY));
        }
        if (conf.get(CACHE_LIMIT_KEY) != null) {
            CACHE_LIMIT = Long.parseLong(conf.get(CACHE_LIMIT_KEY));
        }
        if (conf.get(CACHE_PATH_KEY) != null) {
            CACHE_PATH = conf.get(CACHE_PATH_KEY);
        }
        if (conf.get(USER_KEY) != null) {
            USER = conf.get(USER_KEY);
        }
        if (conf.get(SHADOW_REPLICATION_KEY) != null) {
            SHADOW_REPLICATION = Integer.parseInt(conf.get(SHADOW_REPLICATION_KEY));
        }
        if (conf.get(DEBUG_KEY) != null) {
            DEBUG = Boolean.parseBoolean(conf.get(DEBUG_KEY));
        }
        if (conf.get(STATISTICS_KEY) != null) {
            STATISTICS = Boolean.parseBoolean(conf.get(STATISTICS_KEY));
        }
        if (conf.get(RPC_TIMEOUT_KEY) != null) {
            RPC_TIMEOUT = Integer.parseInt(conf.get(RPC_TIMEOUT_KEY));
        }
        if (conf.get(DATA_TIMEOUT_KEY) != null) {
            DATA_TIMEOUT = Integer.parseInt(conf.get(DATA_TIMEOUT_KEY));
        }
        if (conf.get(BUFFER_SIZE_KEY) != null) {
            BUFFER_SIZE = Integer.parseInt(conf.get(BUFFER_SIZE_KEY));
        }
        if (conf.get(SLICE_SIZE_KEY) != null) {
            SLICE_SIZE = Integer.parseInt(conf.get(SLICE_SIZE_KEY));
        }
        if (conf.get(SINGLETON_KEY) != null) {
            SINGLETON = conf.getBoolean(SINGLETON_KEY, false);
        }
        if (conf.get(REGION_SIZE_KEY) != null) {
            REGION_SIZE = Integer.parseInt(conf.get(REGION_SIZE_KEY));
        }
        if (conf.get(DIRECTORY_RECORD_KEY) != null) {
            DIRECTORY_RECORD = Integer.parseInt(conf.get(DIRECTORY_RECORD_KEY));
        }
        if (conf.get(DIRECTORY_RANDOMIZE_KEY) != null) {
            DIRECTORY_RANDOMIZE = conf.getBoolean(DIRECTORY_RANDOMIZE_KEY, false);
        }
        if (conf.get(CACHE_IMPL_KEY) != null) {
            CACHE_IMPL = conf.get(CACHE_IMPL_KEY);
        }
        if (conf.get(LOCATION_MAP_KEY) != null) {
            LOCATION_MAP = conf.get(LOCATION_MAP_KEY);
        }
        if (conf.get(NAMENODE_ADDRESS_KEY) != null) {
            NAMENODE_ADDRESS = conf.get(NAMENODE_ADDRESS_KEY);
        }
        if (conf.get(NAMENODE_BLOCKSELECTION_KEY) != null) {
            NAMENODE_BLOCKSELECTION = conf.get(NAMENODE_BLOCKSELECTION_KEY);
        }
        if (conf.get(NAMENODE_FILEBLOCKS_KEY) != null) {
            NAMENODE_FILEBLOCKS = Integer.parseInt(conf.get(NAMENODE_FILEBLOCKS_KEY));
        }
        if (conf.get(NAMENODE_RPC_TYPE_KEY) != null) {
            NAMENODE_RPC_TYPE = conf.get(NAMENODE_RPC_TYPE_KEY);
        }
        if (conf.get(NAMENODE_LOG_KEY) != null) {
            NAMENODE_LOG = conf.get(NAMENODE_LOG_KEY);
        }
        if (conf.get(STORAGE_TYPES_KEY) != null) {
            STORAGE_TYPES = conf.get(STORAGE_TYPES_KEY);
        }
        STORAGE_CLASSES = conf.get(STORAGE_CLASSES_KEY) != null ? Math.max(Integer.parseInt(conf.get(STORAGE_CLASSES_KEY)), CrailUtils.getStorageClasses(STORAGE_TYPES)) : CrailUtils.getStorageClasses(STORAGE_TYPES);
        if (conf.get(STORAGE_ROOTCLASS_KEY) != null) {
            STORAGE_ROOTCLASS = Integer.parseInt(conf.get(STORAGE_ROOTCLASS_KEY));
        }
        if (conf.get(STORAGE_KEEPALIVE_KEY) != null) {
            STORAGE_KEEPALIVE = Integer.parseInt(conf.get(STORAGE_KEEPALIVE_KEY));
        }
    }

    public static void printConf() {
        LOG.info("crail.version " + VERSION);
        LOG.info("crail.directorydepth " + DIRECTORY_DEPTH);
        LOG.info("crail.tokenexpiration " + TOKEN_EXPIRATION);
        LOG.info("crail.blocksize " + BLOCK_SIZE);
        LOG.info("crail.cachelimit " + CACHE_LIMIT);
        LOG.info("crail.cachepath " + CACHE_PATH);
        LOG.info("crail.user " + USER);
        LOG.info("crail.shadowreplication " + SHADOW_REPLICATION);
        LOG.info("crail.debug " + DEBUG);
        LOG.info("crail.statistics " + STATISTICS);
        LOG.info("crail.rpctimeout " + RPC_TIMEOUT);
        LOG.info("crail.datatimeout " + DATA_TIMEOUT);
        LOG.info("crail.buffersize " + BUFFER_SIZE);
        LOG.info("crail.slicesize " + SLICE_SIZE);
        LOG.info("crail.singleton " + SINGLETON);
        LOG.info("crail.regionsize " + REGION_SIZE);
        LOG.info("crail.directoryrecord " + DIRECTORY_RECORD);
        LOG.info("crail.directoryrandomize " + DIRECTORY_RANDOMIZE);
        LOG.info("crail.cacheimpl " + CACHE_IMPL);
        LOG.info("crail.locationmap " + LOCATION_MAP);
        LOG.info("crail.namenode.address " + NAMENODE_ADDRESS);
        LOG.info("crail.namenode.blockselection " + NAMENODE_BLOCKSELECTION);
        LOG.info("crail.namenode.fileblocks " + NAMENODE_FILEBLOCKS);
        LOG.info("crail.namenode.rpctype " + NAMENODE_RPC_TYPE);
        LOG.info("crail.namenode.log " + NAMENODE_LOG);
        LOG.info("crail.storage.types " + STORAGE_TYPES);
        LOG.info("crail.storage.classes " + STORAGE_CLASSES);
        LOG.info("crail.storage.rootclass " + STORAGE_ROOTCLASS);
        LOG.info("crail.storage.keepalive " + STORAGE_KEEPALIVE);
    }

    public static void verify() throws IOException {
        if (BUFFER_SIZE % DIRECTORY_RECORD != 0) {
            throw new IOException("crail.buffersize must be multiple of " + DIRECTORY_RECORD);
        }
        if (Math.max(BUFFER_SIZE, SLICE_SIZE) % Math.min(BUFFER_SIZE, SLICE_SIZE) != 0) {
            throw new IOException("crail.slicesize must be multiple of buffersize " + BUFFER_SIZE);
        }
        if (STORAGE_CLASSES < CrailUtils.getStorageClasses(STORAGE_TYPES)) {
            throw new IOException("crail.storage.classes cannot be smaller than the number of storage types " + CrailUtils.getStorageClasses(STORAGE_TYPES));
        }
    }
}

