/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.crail.CrailBufferedInputStream;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailInputStream;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailStore;
import org.apache.crail.utils.RingBuffer;

class MultiFileBufferedInputStream
extends CrailBufferedInputStream {
    private CrailStore fs;
    private Iterator<String> paths;
    private RingBuffer<CrailInputStream> readyStreams;
    private LinkedList<CrailInputStream> finalStreams;

    MultiFileBufferedInputStream(CrailStore fs, Iterator<String> paths, int outstanding, int files) throws Exception {
        super(fs, outstanding, 0L);
        this.fs = fs;
        this.paths = paths;
        this.readyStreams = new RingBuffer(1);
        this.finalStreams = new LinkedList();
    }

    @Override
    public CrailInputStream getStream() throws Exception {
        while (this.readyStreams.isEmpty() && this.paths.hasNext()) {
            CrailFile file;
            String path = this.paths.next();
            CrailNode node = (CrailNode)this.fs.lookup(path).get();
            if (node == null || (file = node.asFile()).getCapacity() <= 0L) continue;
            CrailInputStream stream = file.getDirectInputStream(file.getCapacity());
            this.readyStreams.add(stream);
        }
        return this.readyStreams.peek();
    }

    @Override
    public void putStream() throws Exception {
        CrailInputStream stream = this.readyStreams.peek();
        if (stream.position() >= stream.getFile().getCapacity()) {
            stream = this.readyStreams.poll();
            this.finalStreams.add(stream);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            while (!this.readyStreams.isEmpty()) {
                this.finalStreams.add(this.readyStreams.poll());
            }
            while (this.paths.hasNext()) {
                String path = this.paths.next();
                CrailFile file = ((CrailNode)this.fs.lookup(path).get()).asFile();
                if (file == null) continue;
                CrailInputStream stream = file.getDirectInputStream(file.getCapacity());
                this.finalStreams.add(stream);
            }
            while (!this.finalStreams.isEmpty()) {
                CrailInputStream stream = this.finalStreams.poll();
                stream.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        throw new IOException("Seek not supported on multistream");
    }
}

