/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail;

import java.io.IOException;
import org.apache.crail.CrailBufferedInputStream;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailInputStream;
import org.apache.crail.conf.CrailConstants;

class FileBufferedInputStream
extends CrailBufferedInputStream {
    private CrailInputStream inputStream;

    FileBufferedInputStream(CrailFile file, long readHint) throws Exception {
        super(file.getFileSystem(), Math.max(CrailConstants.BUFFER_SIZE, CrailConstants.SLICE_SIZE) / Math.min(CrailConstants.BUFFER_SIZE, CrailConstants.SLICE_SIZE), file.getCapacity());
        this.inputStream = file.getDirectInputStream(readHint);
    }

    @Override
    public CrailInputStream getStream() throws Exception {
        return this.inputStream;
    }

    @Override
    public void putStream() throws Exception {
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.inputStream.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

