/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma.client;

import com.ibm.disni.RdmaPassiveEndpointGroup;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.rdma.MrCache;
import org.apache.crail.storage.rdma.RdmaConstants;
import org.apache.crail.storage.rdma.RdmaStorageGroup;
import org.apache.crail.storage.rdma.client.RdmaStorageLocalEndpoint;
import org.apache.crail.storage.rdma.client.RdmaStoragePassiveEndpoint;
import org.apache.crail.utils.CrailUtils;

public class RdmaStoragePassiveGroup
extends RdmaPassiveEndpointGroup<RdmaStoragePassiveEndpoint>
implements RdmaStorageGroup {
    private HashMap<InetSocketAddress, RdmaStorageLocalEndpoint> localCache;
    private MrCache mrCache;

    public RdmaStoragePassiveGroup(int timeout, int maxWR, int maxSge, int cqSize, MrCache mrCache) throws IOException {
        super(timeout, maxWR, maxSge, cqSize);
        try {
            this.mrCache = mrCache;
            this.localCache = new HashMap();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public StorageEndpoint createEndpoint(DataNodeInfo info) throws IOException {
        try {
            return this.createEndpoint(CrailUtils.datanodeInfo2SocketAddr((DataNodeInfo)info));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public StorageEndpoint createEndpoint(InetSocketAddress inetAddress) throws Exception {
        if (RdmaConstants.STORAGE_RDMA_LOCAL_MAP && CrailUtils.isLocalAddress((InetAddress)inetAddress.getAddress())) {
            RdmaStorageLocalEndpoint localEndpoint = this.localCache.get(inetAddress.getAddress());
            if (localEndpoint == null) {
                localEndpoint = new RdmaStorageLocalEndpoint(inetAddress);
                this.localCache.put(inetAddress, localEndpoint);
            }
            return localEndpoint;
        }
        RdmaStoragePassiveEndpoint endpoint = (RdmaStoragePassiveEndpoint)super.createEndpoint();
        endpoint.connect(inetAddress, RdmaConstants.STORAGE_RDMA_CONNECTTIMEOUT);
        return endpoint;
    }

    @Override
    public int getType() {
        return 0;
    }

    public String toString() {
        return "maxWR " + this.getMaxWR() + ", maxSge " + this.getMaxSge() + ", cqSize " + this.getCqSize();
    }

    public MrCache getMrCache() {
        return this.mrCache;
    }
}

