/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma.client;

import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.RdmaCmId;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.CrailBuffer;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.memory.OffHeapBuffer;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.StorageUtils;
import org.apache.crail.storage.rdma.RdmaConstants;
import org.apache.crail.storage.rdma.client.RdmaLocalFuture;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;
import sun.misc.Unsafe;

public class RdmaStorageLocalEndpoint
implements StorageEndpoint {
    private static final Logger LOG = CrailUtils.getLogger();
    private ConcurrentHashMap<Long, CrailBuffer> bufferMap;
    private Unsafe unsafe;
    private InetSocketAddress address;

    public RdmaStorageLocalEndpoint(InetSocketAddress datanodeAddr) throws Exception {
        LOG.info("new local endpoint for address " + datanodeAddr);
        String dataPath = StorageUtils.getDatanodeDirectory((String)RdmaConstants.STORAGE_RDMA_DATA_PATH, (InetSocketAddress)datanodeAddr);
        File dataDir = new File(dataPath);
        if (!dataDir.exists()) {
            throw new Exception("Local RDMA data path missing");
        }
        this.address = datanodeAddr;
        this.bufferMap = new ConcurrentHashMap();
        this.unsafe = this.getUnsafe();
        for (File dataFile : dataDir.listFiles()) {
            long lba = Long.parseLong(dataFile.getName());
            OffHeapBuffer offHeapBuffer = OffHeapBuffer.wrap((ByteBuffer)this.mmap(dataFile));
            this.bufferMap.put(lba, (CrailBuffer)offHeapBuffer);
        }
    }

    public StorageFuture write(CrailBuffer buffer, BlockInfo remoteMr, long remoteOffset) throws IOException, InterruptedException {
        if ((long)buffer.remaining() > CrailConstants.BLOCK_SIZE) {
            throw new IOException("write size too large " + buffer.remaining());
        }
        if (buffer.remaining() <= 0) {
            throw new IOException("write size too small, len " + buffer.remaining());
        }
        if (remoteOffset < 0L) {
            throw new IOException("remote offset too small " + remoteOffset);
        }
        long alignedLba = RdmaStorageLocalEndpoint.getAlignedLba(remoteMr.getLba());
        long lbaOffset = RdmaStorageLocalEndpoint.getLbaOffset(remoteMr.getLba());
        CrailBuffer mappedBuffer = this.bufferMap.get(alignedLba);
        if (mappedBuffer == null) {
            throw new IOException("No mapped buffer for this key " + remoteMr.getLkey() + ", address " + this.address);
        }
        if (lbaOffset + remoteOffset + (long)buffer.remaining() > RdmaConstants.STORAGE_RDMA_ALLOCATION_SIZE) {
            long tmpAddr = lbaOffset + remoteOffset + (long)buffer.remaining();
            throw new IOException("remote fileOffset + remoteOffset + len too large " + tmpAddr);
        }
        long srcAddr = buffer.address() + (long)buffer.position();
        long dstAddr = mappedBuffer.address() + lbaOffset + remoteOffset;
        RdmaLocalFuture future = new RdmaLocalFuture(this.unsafe, srcAddr, dstAddr, buffer.remaining());
        return future;
    }

    public StorageFuture read(CrailBuffer buffer, BlockInfo remoteMr, long remoteOffset) throws IOException, InterruptedException {
        if ((long)buffer.remaining() > CrailConstants.BLOCK_SIZE) {
            throw new IOException("read size too large");
        }
        if (buffer.remaining() <= 0) {
            throw new IOException("read size too small, len " + buffer.remaining());
        }
        if (remoteOffset < 0L) {
            throw new IOException("remote offset too small " + remoteOffset);
        }
        if (buffer.position() < 0) {
            throw new IOException("local offset too small " + buffer.position());
        }
        long alignedLba = RdmaStorageLocalEndpoint.getAlignedLba(remoteMr.getLba());
        long lbaOffset = RdmaStorageLocalEndpoint.getLbaOffset(remoteMr.getLba());
        CrailBuffer mappedBuffer = this.bufferMap.get(alignedLba);
        if (mappedBuffer == null) {
            throw new IOException("No mapped buffer for this key");
        }
        if (lbaOffset + remoteOffset + (long)buffer.remaining() > RdmaConstants.STORAGE_RDMA_ALLOCATION_SIZE) {
            long tmpAddr = lbaOffset + remoteOffset + (long)buffer.remaining();
            throw new IOException("remote fileOffset + remoteOffset + len too large " + tmpAddr);
        }
        long srcAddr = mappedBuffer.address() + lbaOffset + remoteOffset;
        long dstAddr = buffer.address() + (long)buffer.position();
        RdmaLocalFuture future = new RdmaLocalFuture(this.unsafe, srcAddr, dstAddr, buffer.remaining());
        return future;
    }

    private static long getAlignedLba(long remoteLba) {
        return remoteLba / RdmaConstants.STORAGE_RDMA_ALLOCATION_SIZE;
    }

    private static long getLbaOffset(long remoteLba) {
        return remoteLba % RdmaConstants.STORAGE_RDMA_ALLOCATION_SIZE;
    }

    public void close() throws IOException, InterruptedException {
    }

    public void connect(SocketAddress inetAddress, int i) throws InterruptedException, IOException {
    }

    public int getEndpointId() {
        return 0;
    }

    public int getFreeSlots() {
        return 0;
    }

    public boolean isConnected() {
        return true;
    }

    public IbvQP getQp() {
        return null;
    }

    public String getAddress() throws IOException {
        return null;
    }

    public RdmaCmId getContext() {
        return null;
    }

    private MappedByteBuffer mmap(File file) throws IOException {
        RandomAccessFile randomFile = new RandomAccessFile(file.getAbsolutePath(), "rw");
        FileChannel channel = randomFile.getChannel();
        MappedByteBuffer mappedBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, RdmaConstants.STORAGE_RDMA_ALLOCATION_SIZE);
        randomFile.close();
        return mappedBuffer;
    }

    private Unsafe getUnsafe() throws Exception {
        Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafe.setAccessible(true);
        Unsafe unsafe = (Unsafe)theUnsafe.get(null);
        return unsafe;
    }

    public boolean isLocal() {
        return true;
    }
}

