/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.storage.StorageResult;
import sun.misc.Unsafe;

public class RdmaLocalFuture
implements StorageFuture,
StorageResult {
    private Unsafe unsafe;
    private long srcAddr;
    private long dstAddr;
    private int remaining;
    private int len;
    private boolean isDone;

    public RdmaLocalFuture(Unsafe unsafe, long srcAddr, long dstAddr, int remaining) {
        this.unsafe = unsafe;
        this.srcAddr = srcAddr;
        this.dstAddr = dstAddr;
        this.remaining = remaining;
        this.len = 0;
        this.isDone = false;
    }

    public int getLen() {
        return this.len;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        if (!this.isDone) {
            this.getDone();
        }
        return this.isDone;
    }

    public StorageResult get() throws InterruptedException, ExecutionException {
        if (!this.isDone) {
            this.getDone();
        }
        return this;
    }

    public StorageResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.isDone) {
            this.getDone();
        }
        return this;
    }

    public boolean isSynchronous() {
        return true;
    }

    void getDone() {
        this.unsafe.copyMemory(this.srcAddr, this.dstAddr, this.remaining);
        this.len = this.remaining;
        this.isDone = true;
    }
}

