/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma;

import com.ibm.disni.RdmaActiveEndpointGroup;
import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.RdmaEndpointFactory;
import com.ibm.disni.RdmaServerEndpoint;
import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.SVCRegMr;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.storage.StorageResource;
import org.apache.crail.storage.StorageServer;
import org.apache.crail.storage.StorageUtils;
import org.apache.crail.storage.rdma.RdmaConstants;
import org.apache.crail.storage.rdma.RdmaStorageEndpointFactory;
import org.apache.crail.storage.rdma.RdmaStorageServerEndpoint;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class RdmaStorageServer
implements Runnable,
StorageServer {
    private static final Logger LOG = CrailUtils.getLogger();
    private InetSocketAddress serverAddr = null;
    private RdmaActiveEndpointGroup<RdmaStorageServerEndpoint> datanodeGroup = null;
    private RdmaServerEndpoint<RdmaStorageServerEndpoint> datanodeServerEndpoint = null;
    private ConcurrentHashMap<Integer, RdmaEndpoint> allEndpoints = new ConcurrentHashMap();
    private boolean isAlive = false;
    private String dataDirPath;
    private long allocatedSize;
    private int fileCount;

    public void init(CrailConfiguration conf, String[] args) throws Exception {
        RdmaConstants.init(conf, args);
        this.serverAddr = StorageUtils.getDataNodeAddress((String)RdmaConstants.STORAGE_RDMA_INTERFACE, (int)RdmaConstants.STORAGE_RDMA_PORT);
        if (this.serverAddr == null) {
            LOG.info("Configured network interface " + RdmaConstants.STORAGE_RDMA_INTERFACE + " cannot be found..exiting!!!");
            return;
        }
        this.datanodeGroup = new RdmaActiveEndpointGroup(-1, false, 1, 1, 1);
        this.datanodeServerEndpoint = this.datanodeGroup.createServerEndpoint();
        this.datanodeGroup.init((RdmaEndpointFactory)new RdmaStorageEndpointFactory(this.datanodeGroup, this));
        this.datanodeServerEndpoint.bind((SocketAddress)this.serverAddr, RdmaConstants.STORAGE_RDMA_BACKLOG);
        this.allocatedSize = 0L;
        this.fileCount = 0;
        this.dataDirPath = StorageUtils.getDatanodeDirectory((String)RdmaConstants.STORAGE_RDMA_DATA_PATH, (InetSocketAddress)this.serverAddr);
        if (!RdmaConstants.STORAGE_RDMA_PERSISTENT) {
            StorageUtils.clean((String)RdmaConstants.STORAGE_RDMA_DATA_PATH, (String)this.dataDirPath);
        }
    }

    public void printConf(Logger logger) {
        RdmaConstants.printConf(logger);
    }

    public void close(RdmaEndpoint ep) {
        try {
            this.allEndpoints.remove(ep.getEndpointId());
            ep.close();
            LOG.info("removing endpoint, connCount " + this.allEndpoints.size());
        }
        catch (Exception e) {
            LOG.info("error closing " + e.getMessage());
        }
    }

    public StorageResource allocateResource() throws Exception {
        StorageResource resource = null;
        if (this.allocatedSize < RdmaConstants.STORAGE_RDMA_STORAGE_LIMIT) {
            int fileId = this.fileCount++;
            String dataFilePath = this.dataDirPath + "/" + fileId;
            RandomAccessFile dataFile = new RandomAccessFile(dataFilePath, "rw");
            if (!RdmaConstants.STORAGE_RDMA_PERSISTENT) {
                dataFile.setLength(RdmaConstants.STORAGE_RDMA_ALLOCATION_SIZE);
            }
            FileChannel dataChannel = dataFile.getChannel();
            MappedByteBuffer dataBuffer = dataChannel.map(FileChannel.MapMode.READ_WRITE, 0L, RdmaConstants.STORAGE_RDMA_ALLOCATION_SIZE);
            dataFile.close();
            dataChannel.close();
            this.allocatedSize += (long)dataBuffer.capacity();
            IbvMr mr = ((SVCRegMr)((SVCRegMr)this.datanodeServerEndpoint.registerMemory((ByteBuffer)dataBuffer).execute()).free()).getMr();
            resource = StorageResource.createResource((long)mr.getAddr(), (int)mr.getLength(), (int)mr.getLkey());
        }
        return resource;
    }

    @Override
    public void run() {
        try {
            this.isAlive = true;
            LOG.info("rdma storage server started, address " + this.serverAddr + ", persistent " + RdmaConstants.STORAGE_RDMA_PERSISTENT + ", maxWR " + this.datanodeGroup.getMaxWR() + ", maxSge " + this.datanodeGroup.getMaxSge() + ", cqSize " + this.datanodeGroup.getCqSize());
            while (true) {
                RdmaEndpoint clientEndpoint = this.datanodeServerEndpoint.accept();
                this.allEndpoints.put(clientEndpoint.getEndpointId(), clientEndpoint);
                LOG.info("accepting client connection, conncount " + this.allEndpoints.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isAlive = false;
            return;
        }
    }

    public InetSocketAddress getAddress() {
        return this.serverAddr;
    }

    public boolean isAlive() {
        return this.isAlive;
    }
}

