/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage.rdma;

import java.io.IOException;
import org.apache.crail.CrailBufferCache;
import org.apache.crail.CrailStatistics;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.storage.StorageClient;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.rdma.MrCache;
import org.apache.crail.storage.rdma.RdmaConstants;
import org.apache.crail.storage.rdma.RdmaStorageGroup;
import org.apache.crail.storage.rdma.client.RdmaStorageActiveEndpointFactory;
import org.apache.crail.storage.rdma.client.RdmaStorageActiveGroup;
import org.apache.crail.storage.rdma.client.RdmaStoragePassiveEndpointFactory;
import org.apache.crail.storage.rdma.client.RdmaStoragePassiveGroup;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class RdmaStorageClient
implements StorageClient {
    private static final Logger LOG = CrailUtils.getLogger();
    private MrCache clientMrCache = null;
    private RdmaStorageGroup clientGroup = null;

    public void init(CrailStatistics statistics, CrailBufferCache bufferCache, CrailConfiguration conf, String[] args) throws IOException {
        RdmaConstants.init(conf, args);
    }

    public void printConf(Logger logger) {
        RdmaConstants.printConf(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageEndpoint createEndpoint(DataNodeInfo info) throws IOException {
        RdmaStorageClient rdmaStorageClient;
        if (this.clientMrCache == null) {
            rdmaStorageClient = this;
            synchronized (rdmaStorageClient) {
                if (this.clientMrCache == null) {
                    this.clientMrCache = new MrCache();
                }
            }
        }
        if (this.clientGroup == null) {
            rdmaStorageClient = this;
            synchronized (rdmaStorageClient) {
                if (this.clientGroup == null) {
                    if (RdmaConstants.STORAGE_RDMA_TYPE.equalsIgnoreCase("passive")) {
                        LOG.info("passive data client ");
                        RdmaStoragePassiveGroup _endpointGroup = new RdmaStoragePassiveGroup(100, RdmaConstants.STORAGE_RDMA_QUEUESIZE, 4, RdmaConstants.STORAGE_RDMA_QUEUESIZE * 2, this.clientMrCache);
                        _endpointGroup.init(new RdmaStoragePassiveEndpointFactory(_endpointGroup));
                        this.clientGroup = _endpointGroup;
                    } else {
                        LOG.info("active data client ");
                        RdmaStorageActiveGroup _endpointGroup = new RdmaStorageActiveGroup(100, false, RdmaConstants.STORAGE_RDMA_QUEUESIZE, 4, RdmaConstants.STORAGE_RDMA_QUEUESIZE * 2, this.clientMrCache);
                        _endpointGroup.init(new RdmaStorageActiveEndpointFactory(_endpointGroup));
                        this.clientGroup = _endpointGroup;
                    }
                }
            }
        }
        return this.clientGroup.createEndpoint(info);
    }

    public void close() throws Exception {
        if (this.clientGroup != null) {
            this.clientGroup.close();
        }
    }
}

