/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.crail.CrailStorageClass;
import org.apache.crail.conf.Configurable;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.DataNodeStatistics;
import org.apache.crail.rpc.RpcClient;
import org.apache.crail.rpc.RpcConnection;
import org.apache.crail.rpc.RpcDispatcher;
import org.apache.crail.storage.StorageResource;
import org.apache.crail.storage.StorageRpcClient;
import org.apache.crail.storage.StorageTier;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public interface StorageServer
extends Configurable,
Runnable {
    public StorageResource allocateResource() throws Exception;

    public boolean isAlive();

    public InetSocketAddress getAddress();

    public static void main(String[] args) throws Exception {
        StorageResource resource;
        StorageTier storageTier;
        Logger LOG = CrailUtils.getLogger();
        CrailConfiguration conf = CrailConfiguration.createConfigurationFromFile();
        CrailConstants.updateConstants((CrailConfiguration)conf);
        CrailConstants.printConf();
        CrailConstants.verify();
        int splitIndex = 0;
        for (String param : args) {
            if (param.equalsIgnoreCase("--")) break;
            ++splitIndex;
        }
        StringTokenizer tokenizer = new StringTokenizer(CrailConstants.STORAGE_TYPES, ",");
        if (!tokenizer.hasMoreTokens()) {
            throw new Exception("No storage types defined!");
        }
        String storageName = tokenizer.nextToken();
        int storageType = 0;
        HashMap<String, Integer> storageTypes = new HashMap<String, Integer>();
        storageTypes.put(storageName, storageType);
        int type = 1;
        while (tokenizer.hasMoreElements()) {
            String name = tokenizer.nextToken();
            storageTypes.put(name, type);
            ++type;
        }
        int storageClass = -1;
        if (args != null) {
            Option typeOption = Option.builder((String)"t").desc("storage type to start").hasArg().build();
            Option classOption = Option.builder((String)"c").desc("storage class the server will attach to").hasArg().build();
            Options options = new Options();
            options.addOption(typeOption);
            options.addOption(classOption);
            DefaultParser parser = new DefaultParser();
            try {
                CommandLine line = parser.parse(options, Arrays.copyOfRange(args, 0, splitIndex));
                if (line.hasOption(typeOption.getOpt())) {
                    storageName = line.getOptionValue(typeOption.getOpt());
                    storageType = (Integer)storageTypes.get(storageName);
                }
                if (line.hasOption(classOption.getOpt())) {
                    storageClass = Integer.parseInt(line.getOptionValue(classOption.getOpt()));
                }
            }
            catch (ParseException e) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("Storage tier", options);
                System.exit(-1);
            }
        }
        if (storageClass < 0) {
            storageClass = storageType;
        }
        if ((storageTier = StorageTier.createInstance(storageName)) == null) {
            throw new Exception("Cannot instantiate datanode of type " + storageName);
        }
        StorageServer server = storageTier.launchServer();
        String[] extraParams = null;
        if (args.length > ++splitIndex) {
            extraParams = new String[args.length - splitIndex];
            for (int i = splitIndex; i < args.length; ++i) {
                extraParams[i - splitIndex] = args[i];
            }
        }
        server.init(conf, extraParams);
        server.printConf(LOG);
        Thread thread = new Thread(server);
        thread.start();
        RpcClient rpcClient = RpcClient.createInstance((String)CrailConstants.NAMENODE_RPC_TYPE);
        rpcClient.init(conf, args);
        rpcClient.printConf(LOG);
        ConcurrentLinkedQueue namenodeList = CrailUtils.getNameNodeList();
        ConcurrentLinkedQueue<RpcConnection> connectionList = new ConcurrentLinkedQueue<RpcConnection>();
        while (!namenodeList.isEmpty()) {
            InetSocketAddress address = (InetSocketAddress)namenodeList.poll();
            RpcConnection connection = rpcClient.connect(address);
            connectionList.add(connection);
        }
        RpcConnection rpcConnection = (RpcConnection)connectionList.peek();
        if (connectionList.size() > 1) {
            rpcConnection = new RpcDispatcher(connectionList);
        }
        LOG.info("connected to namenode(s) " + rpcConnection.toString());
        StorageRpcClient storageRpc = new StorageRpcClient(storageType, CrailStorageClass.get((int)storageClass), server.getAddress(), rpcConnection);
        HashMap<Long, Long> blockCount = new HashMap<Long, Long>();
        long sumCount = 0L;
        long lba = 0L;
        while (server.isAlive() && (resource = server.allocateResource()) != null) {
            storageRpc.setBlock(lba, resource.getAddress(), resource.getLength(), resource.getKey());
            lba += (long)resource.getLength();
            DataNodeStatistics stats = storageRpc.getDataNode();
            long newCount = stats.getFreeBlockCount();
            long serviceId = stats.getServiceId();
            long oldCount = 0L;
            if (blockCount.containsKey(serviceId)) {
                oldCount = (Long)blockCount.get(serviceId);
            }
            long diffCount = newCount - oldCount;
            blockCount.put(serviceId, newCount);
            LOG.info("datanode statistics, freeBlocks " + (sumCount += diffCount));
        }
        while (server.isAlive()) {
            DataNodeStatistics stats = storageRpc.getDataNode();
            long newCount = stats.getFreeBlockCount();
            long serviceId = stats.getServiceId();
            long oldCount = 0L;
            if (blockCount.containsKey(serviceId)) {
                oldCount = (Long)blockCount.get(serviceId);
            }
            long diffCount = newCount - oldCount;
            blockCount.put(serviceId, newCount);
            LOG.info("datanode statistics, freeBlocks " + (sumCount += diffCount));
            Thread.sleep(CrailConstants.STORAGE_KEEPALIVE * 1000);
        }
    }
}

