/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.storage;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.crail.CrailLocationClass;
import org.apache.crail.CrailStorageClass;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.metadata.DataNodeStatistics;
import org.apache.crail.rpc.RpcConnection;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.rpc.RpcGetDataNode;
import org.apache.crail.rpc.RpcVoid;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class StorageRpcClient {
    public static final Logger LOG = CrailUtils.getLogger();
    private InetSocketAddress serverAddress;
    private int storageType;
    private CrailStorageClass storageClass;
    private CrailLocationClass locationClass;
    private RpcConnection rpcConnection;

    public StorageRpcClient(int storageType, CrailStorageClass storageClass, InetSocketAddress serverAddress, RpcConnection rpcConnection) throws Exception {
        this.storageType = storageType;
        this.storageClass = storageClass;
        this.serverAddress = serverAddress;
        this.locationClass = CrailUtils.getLocationClass();
        this.rpcConnection = rpcConnection;
    }

    public void setBlock(long lba, long addr, int length, int key) throws Exception {
        InetSocketAddress inetAddress = this.serverAddress;
        DataNodeInfo dnInfo = new DataNodeInfo(this.storageType, this.storageClass.value(), this.locationClass.value(), inetAddress.getAddress().getAddress(), inetAddress.getPort());
        BlockInfo blockInfo = new BlockInfo(dnInfo, lba, addr, length, key);
        RpcVoid res = (RpcVoid)this.rpcConnection.setBlock(blockInfo).get((long)CrailConstants.RPC_TIMEOUT, TimeUnit.MILLISECONDS);
        if (res.getError() != RpcErrors.ERR_OK) {
            LOG.info("setBlock: " + RpcErrors.messages[res.getError()]);
            throw new IOException("setBlock: " + RpcErrors.messages[res.getError()]);
        }
    }

    public DataNodeStatistics getDataNode() throws Exception {
        InetSocketAddress inetAddress = this.serverAddress;
        DataNodeInfo dnInfo = new DataNodeInfo(this.storageType, this.storageClass.value(), this.locationClass.value(), inetAddress.getAddress().getAddress(), inetAddress.getPort());
        return ((RpcGetDataNode)this.rpcConnection.getDataNode(dnInfo).get((long)CrailConstants.RPC_TIMEOUT, TimeUnit.MILLISECONDS)).getStatistics();
    }
}

