/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SockAddrIn {
    public static short AF_INET = (short)2;
    public static int CSIZE = 28;
    protected short sin_family;
    protected int sin_addr;
    protected short sin_port;
    protected byte[] sin_zero;

    SockAddrIn() {
        this.sin_family = AF_INET;
        this.sin_addr = 0;
        this.sin_port = 0;
        this.sin_zero = new byte[8];
    }

    SockAddrIn(short sin_family, int sin_addr, short sin_port) {
        this.sin_family = sin_family;
        this.sin_addr = sin_addr;
        this.sin_port = sin_port;
        this.sin_zero = new byte[8];
    }

    public void writeBack(ByteBuffer buffer) {
        buffer.putShort(this.sin_family);
        buffer.putShort(this.sin_port);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.sin_addr);
        buffer.order(ByteOrder.nativeOrder());
    }

    public void update(ByteBuffer buffer) {
        this.sin_family = buffer.getShort();
        this.sin_port = buffer.getShort();
        this.sin_addr = buffer.getInt();
    }

    public int size() {
        return CSIZE;
    }

    public short getSin_family() {
        return this.sin_family;
    }

    public void setSin_family(short sin_family) {
        this.sin_family = sin_family;
    }

    public short getSin_port() {
        return this.sin_port;
    }

    public void setSin_port(short sin_port) {
        this.sin_port = sin_port;
    }

    public int getSin_addr() {
        return this.sin_addr;
    }

    public void setSin_addr(int sin_addr) {
        this.sin_addr = sin_addr;
    }

    public byte[] getSin_zero() {
        return this.sin_zero;
    }

    public void setSin_zero(byte[] sin_zero) {
        this.sin_zero = sin_zero;
    }

    public String getClassName() {
        return SockAddrIn.class.getCanonicalName();
    }
}

