/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.util.MemoryAllocation;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvCompChannel;
import com.ibm.disni.verbs.IbvContext;
import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.IbvQpAttr;
import com.ibm.disni.verbs.IbvRecvWR;
import com.ibm.disni.verbs.IbvSendWR;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.RdmaVerbs;
import com.ibm.disni.verbs.SVCDeregMr;
import com.ibm.disni.verbs.SVCPollCq;
import com.ibm.disni.verbs.SVCPostRecv;
import com.ibm.disni.verbs.SVCPostSend;
import com.ibm.disni.verbs.SVCRegMr;
import com.ibm.disni.verbs.SVCReqNotify;
import com.ibm.disni.verbs.impl.NatDeregMrCall;
import com.ibm.disni.verbs.impl.NatIbvCQ;
import com.ibm.disni.verbs.impl.NatIbvCompChannel;
import com.ibm.disni.verbs.impl.NatIbvContext;
import com.ibm.disni.verbs.impl.NatIbvMr;
import com.ibm.disni.verbs.impl.NatIbvPd;
import com.ibm.disni.verbs.impl.NatIbvQP;
import com.ibm.disni.verbs.impl.NatPollCqCall;
import com.ibm.disni.verbs.impl.NatPostRecvCall;
import com.ibm.disni.verbs.impl.NatPostSendCall;
import com.ibm.disni.verbs.impl.NatRegMrCall;
import com.ibm.disni.verbs.impl.NatReqNotifyCall;
import com.ibm.disni.verbs.impl.NativeDispatcher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;

public class RdmaVerbsNat
extends RdmaVerbs {
    private static final Logger logger = DiSNILogger.getLogger();
    private MemoryAllocation memAlloc = MemoryAllocation.getInstance();
    private NativeDispatcher nativeDispatcher;

    public RdmaVerbsNat(NativeDispatcher nativeDispatcher) {
        this.nativeDispatcher = nativeDispatcher;
    }

    @Override
    public IbvPd allocPd(IbvContext context) throws IOException {
        NatIbvContext natContext = (NatIbvContext)context;
        if (!natContext.isOpen()) {
            throw new IOException("Trying to allocate PD on closed context.");
        }
        long objId = this.nativeDispatcher._allocPd(natContext.getObjId());
        logger.info("allocPd, objId " + objId);
        NatIbvPd pd = null;
        if (objId >= 0L) {
            pd = new NatIbvPd(objId, context, this.nativeDispatcher);
        }
        return pd;
    }

    @Override
    public IbvCompChannel createCompChannel(IbvContext context) throws IOException {
        NatIbvContext natContext = (NatIbvContext)context;
        if (!natContext.isOpen()) {
            throw new IOException("Trying to create completion channel with closed channel.");
        }
        long objId = this.nativeDispatcher._createCompChannel(natContext.getObjId());
        logger.info("createCompChannel, context " + natContext.getObjId());
        NatIbvCompChannel channel = null;
        if (objId >= 0L) {
            channel = new NatIbvCompChannel(objId, 0, context);
        }
        return channel;
    }

    @Override
    public IbvCQ createCQ(IbvContext context, IbvCompChannel compChannel, int ncqe, int comp_vector) throws IOException {
        NatIbvContext natContext = (NatIbvContext)context;
        NatIbvCompChannel natCompChannel = (NatIbvCompChannel)compChannel;
        if (!natContext.isOpen()) {
            throw new IOException("Trying to create CQ with closed context.");
        }
        if (!natCompChannel.isOpen()) {
            throw new IOException("Trying to create CQ with closed completion channel.");
        }
        long objId = this.nativeDispatcher._createCQ(natContext.getObjId(), natCompChannel.getObjId(), ncqe, comp_vector);
        logger.info("createCQ, objId " + objId + ", ncqe " + ncqe);
        NatIbvCQ cq = null;
        if (objId >= 0L) {
            cq = new NatIbvCQ(objId, context, compChannel, 0);
        }
        return cq;
    }

    public IbvQP modifyQP(IbvQP qp, IbvQpAttr attr) throws IOException {
        NatIbvQP natQP = (NatIbvQP)qp;
        if (!qp.isOpen()) {
            throw new IOException("Trying to modify closed QP");
        }
        int ret = this.nativeDispatcher._modifyQP(natQP.getObjId(), 0L);
        logger.info("modifyQP, qpnum " + qp.getQp_num());
        if (ret >= 0) {
            return qp;
        }
        return null;
    }

    @Override
    public SVCRegMr regMr(IbvPd pd, ByteBuffer buffer, int access) {
        return new NatRegMrCall(this, this.nativeDispatcher, this.memAlloc, pd, buffer, access);
    }

    @Override
    public SVCRegMr regMr(IbvPd pd, long address, int length, int access) {
        return new NatRegMrCall(this, this.nativeDispatcher, this.memAlloc, pd, address, length, access);
    }

    @Override
    public int queryOdpSupport(IbvContext context) {
        NatIbvContext natContext = (NatIbvContext)context;
        return this.nativeDispatcher._queryOdpSupport(natContext.getObjId());
    }

    @Override
    public int expPrefetchMr(IbvMr ibvMr, long address, int length) throws IOException {
        return this.nativeDispatcher._expPrefetchMr(((NatIbvMr)ibvMr).getObjId(), address, length);
    }

    @Override
    public SVCDeregMr deregMr(IbvMr mr) {
        return new NatDeregMrCall(this, this.nativeDispatcher, mr);
    }

    @Override
    public SVCPostSend postSend(IbvQP qp, List<IbvSendWR> wrList, List<IbvSendWR> badwrList) {
        return new NatPostSendCall(this, this.nativeDispatcher, this.memAlloc, qp, wrList);
    }

    @Override
    public SVCPostRecv postRecv(IbvQP qp, List<IbvRecvWR> wrList, List<IbvRecvWR> badwrList) {
        return new NatPostRecvCall(this, this.nativeDispatcher, this.memAlloc, qp, wrList);
    }

    @Override
    public boolean getCqEvent(IbvCompChannel compChannel, IbvCQ cq, int timeout) throws IOException {
        NatIbvCompChannel natChannel = (NatIbvCompChannel)compChannel;
        if (!natChannel.isOpen()) {
            throw new IOException("Trying to get CQ event on closed completion channel.");
        }
        int ret = this.nativeDispatcher._getCqEvent(natChannel.getObjId(), timeout);
        return ret >= 0;
    }

    @Override
    public SVCPollCq pollCQ(IbvCQ cq, IbvWC[] wcList, int ne) {
        return new NatPollCqCall(this, this.nativeDispatcher, this.memAlloc, cq, wcList, ne);
    }

    @Override
    public SVCReqNotify reqNotifyCQ(IbvCQ cq, boolean solicited_only) {
        return new NatReqNotifyCall(this, this.nativeDispatcher, cq, solicited_only);
    }

    @Override
    public int ackCqEvents(IbvCQ cq, int nevents) throws IOException {
        NatIbvCQ natCQ = (NatIbvCQ)cq;
        if (!cq.isOpen()) {
            throw new IOException("Trying to acknowledge events on closed CQ.");
        }
        int ret = this.nativeDispatcher._ackCqEvent(natCQ.getObjId(), nevents);
        return ret;
    }

    @Override
    public int destroyCompChannel(IbvCompChannel compChannel) throws IOException {
        logger.info("destroyCompChannel, compChannel " + compChannel.getFd());
        NatIbvCompChannel compChannelImpl = (NatIbvCompChannel)compChannel;
        if (!compChannelImpl.isOpen()) {
            throw new IOException("Trying to destroy an already destroyed completion channel.");
        }
        compChannelImpl.close();
        int ret = this.nativeDispatcher._destroyCompChannel(compChannelImpl.getObjId());
        return ret;
    }

    @Override
    public int deallocPd(IbvPd pd) throws IOException {
        logger.info("deallocPd, pd " + pd.getHandle());
        NatIbvPd pdImpl = (NatIbvPd)pd;
        if (!pdImpl.isOpen()) {
            throw new IOException("Trying to deallocate a closed protection domain.");
        }
        pdImpl.close();
        int ret = this.nativeDispatcher._deallocPd(pdImpl.getObjId());
        return ret;
    }

    @Override
    public int destroyCQ(IbvCQ cq) throws IOException {
        NatIbvCQ cqImpl = (NatIbvCQ)cq;
        logger.info("destroyCQ, cq " + cqImpl.getObjId());
        if (!cqImpl.isOpen()) {
            throw new IOException("Trying to destroy already destroyed CQ.");
        }
        cqImpl.close();
        int ret = this.nativeDispatcher._destroyCQ(cqImpl.getObjId());
        return ret;
    }
}

