/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.impl.NatIbvRecvWR;
import com.ibm.disni.verbs.impl.NatIbvSendWR;
import com.ibm.disni.verbs.impl.NatIbvSge;
import com.ibm.disni.verbs.impl.SockAddrIn;
import java.io.IOException;
import org.slf4j.Logger;

public class NativeDispatcher {
    private static final Logger logger = DiSNILogger.getLogger();
    private static int JVERBS_VERSION = 32;

    NativeDispatcher() throws IOException {
        logger.info("jverbs jni version " + this._getVersion());
        if (this._getVersion() != JVERBS_VERSION) {
            logger.info("jverbs outdated, version found " + this._getVersion() + ", version required " + JVERBS_VERSION);
            throw new IOException("jverbs outdated, version found " + this._getVersion() + ", version required " + JVERBS_VERSION);
        }
        if (this._getSockAddrInSize() != SockAddrIn.CSIZE) {
            logger.info("sock_addr_in size mismatch, jverbs size " + SockAddrIn.CSIZE + ", native size " + this._getSockAddrInSize());
            SockAddrIn.CSIZE = this._getSockAddrInSize();
        } else {
            logger.info("sock_addr_in size match, jverbs size " + SockAddrIn.CSIZE + ", native size " + this._getSockAddrInSize());
        }
        if (this._getIbvRecvWRSize() != NatIbvRecvWR.CSIZE) {
            logger.info("IbvRecvWR size mismatch, jverbs size " + NatIbvRecvWR.CSIZE + ", native size " + this._getIbvRecvWRSize());
            NatIbvRecvWR.CSIZE = this._getIbvRecvWRSize();
        } else {
            logger.info("IbvRecvWR size match, jverbs size " + NatIbvRecvWR.CSIZE + ", native size " + this._getIbvRecvWRSize());
        }
        if (this._getIbvSendWRSize() != NatIbvSendWR.CSIZE) {
            logger.info("IbvSendWR size mismatch, jverbs size " + NatIbvSendWR.CSIZE + ", native size " + this._getIbvSendWRSize());
            NatIbvSendWR.CSIZE = this._getIbvSendWRSize();
        } else {
            logger.info("IbvSendWR size match, jverbs size " + NatIbvSendWR.CSIZE + ", native size " + this._getIbvSendWRSize());
        }
        if (this._getIbvWCSize() != IbvWC.CSIZE) {
            logger.info("IbvWC size mismatch, jverbs size " + IbvWC.CSIZE + ", native size " + this._getIbvWCSize());
            IbvWC.CSIZE = this._getIbvWCSize();
        } else {
            logger.info("IbvWC size match, jverbs size " + IbvWC.CSIZE + ", native size " + this._getIbvWCSize());
        }
        if (this._getIbvSgeSize() != NatIbvSge.CSIZE) {
            logger.info("IbvSge size mismatch, jverbs size " + NatIbvSge.CSIZE + ", native size " + this._getIbvSgeSize());
            NatIbvSge.CSIZE = this._getIbvSgeSize();
        } else {
            logger.info("IbvSge size match, jverbs size " + NatIbvSge.CSIZE + ", native size " + this._getIbvSgeSize());
        }
        if (this._getRemoteAddressOffset() != NatIbvSendWR.REMOTEADDR_OFFSET) {
            logger.info("Remote addr offset mismatch, jverbs size " + NatIbvSendWR.REMOTEADDR_OFFSET + ", native size " + this._getRemoteAddressOffset());
            NatIbvSendWR.REMOTEADDR_OFFSET = this._getRemoteAddressOffset();
        } else {
            logger.info("Remote addr offset match, jverbs size " + NatIbvSendWR.REMOTEADDR_OFFSET + ", native size " + this._getRemoteAddressOffset());
        }
        if (this._getRKeyOffset() != NatIbvSendWR.RKEY_OFFSET) {
            logger.info("Rkey offset mismatch, jverbs size " + NatIbvSendWR.RKEY_OFFSET + ", native size " + this._getRKeyOffset());
            NatIbvSendWR.RKEY_OFFSET = this._getRKeyOffset();
        } else {
            logger.info("Rkey offset match, jverbs size " + NatIbvSendWR.RKEY_OFFSET + ", native size " + this._getRKeyOffset());
        }
    }

    public native long _createEventChannel() throws IOException;

    public native long _createId(long var1, short var3) throws IOException;

    public native long _createQP(long var1, long var3, long var5, long var7, int var9, int var10, int var11, int var12) throws IOException;

    public native void _bindAddr(long var1, long var3) throws IOException;

    public native void _listen(long var1, int var3) throws IOException;

    public native void _resolveAddr(long var1, long var3, long var5, int var7) throws IOException;

    public native void _resolveRoute(long var1, int var3) throws IOException;

    public native int _getCmEvent(long var1, long var3, long var5, int var7);

    public native void _connect(long var1, int var3, int var4, long var5, byte var7) throws IOException;

    public native void _accept(long var1, int var3, int var4) throws IOException;

    public native int _ackCmEvent(int var1);

    public native int _disconnect(long var1);

    public native int _destroyEventChannel(long var1);

    public native int _destroyCmId(long var1);

    public native int _destroyQP(long var1);

    public native int _getSrcAddr(long var1, long var3);

    public native int _getDstAddr(long var1, long var3);

    public native int _destroyEp(long var1);

    public native long _allocPd(long var1) throws IOException;

    public native long _createCompChannel(long var1) throws IOException;

    public native long _createCQ(long var1, long var3, int var5, int var6) throws IOException;

    public native int _modifyQP(long var1, long var3) throws IOException;

    public native long _regMr(long var1, long var3, int var5, int var6, long var7, long var9, long var11) throws IOException;

    public native int _queryOdpSupport(long var1);

    public native int _expPrefetchMr(long var1, long var3, int var5) throws IOException;

    public native void _deregMr(long var1) throws IOException;

    public native void _postSend(long var1, long var3) throws IOException;

    public native void _postRecv(long var1, long var3) throws IOException;

    public native int _getCqEvent(long var1, int var3) throws IOException;

    public native int _pollCQ(long var1, int var3, long var4) throws IOException;

    public native int _reqNotifyCQ(long var1, int var3) throws IOException;

    public native int _ackCqEvent(long var1, int var3);

    public native int _destroyCompChannel(long var1);

    public native int _deallocPd(long var1);

    public native int _destroyCQ(long var1);

    public native long _getContext(long var1) throws IOException;

    public native int _getQpNum(long var1) throws IOException;

    public native int _getContextFd(long var1) throws IOException;

    public native int _getContextNumCompVectors(long var1) throws IOException;

    public native int _getPdHandle(long var1) throws IOException;

    public native int _getSockAddrInSize();

    public native int _getIbvRecvWRSize();

    public native int _getIbvSendWRSize();

    public native int _getIbvSgeSize();

    public native int _getIbvWCSize();

    public native int _getRemoteAddressOffset();

    public native int _getRKeyOffset();

    public native int _getVersion();

    static {
        System.loadLibrary("disni");
    }
}

