/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import com.ibm.disni.util.MemBuf;
import com.ibm.disni.util.MemoryAllocation;
import com.ibm.disni.util.MemoryUtils;
import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.SVCRegMr;
import com.ibm.disni.verbs.impl.NatIbvMr;
import com.ibm.disni.verbs.impl.NatIbvPd;
import com.ibm.disni.verbs.impl.NativeDispatcher;
import com.ibm.disni.verbs.impl.RdmaVerbsNat;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NatRegMrCall
extends SVCRegMr {
    private NativeDispatcher nativeDispatcher;
    private RdmaVerbsNat verbs;
    private MemoryAllocation memAlloc;
    private NatIbvPd pd;
    private int access;
    private int bufferCapacity;
    private MemBuf cmd;
    private long userAddress;
    private IbvMr mr;
    private boolean valid;

    public NatRegMrCall(RdmaVerbsNat verbs, NativeDispatcher nativeDispatcher, MemoryAllocation memAlloc, IbvPd pd, ByteBuffer buffer, int access) {
        this.set(verbs, nativeDispatcher, memAlloc, pd, MemoryUtils.getAddress(buffer), buffer.capacity(), access);
    }

    public NatRegMrCall(RdmaVerbsNat verbs, NativeDispatcher nativeDispatcher, MemoryAllocation memAlloc, IbvPd pd, long address, int length, int access) {
        this.set(verbs, nativeDispatcher, memAlloc, pd, address, length, access);
    }

    private void set(RdmaVerbsNat verbs, NativeDispatcher nativeDispatcher, MemoryAllocation memAlloc, IbvPd pd, long address, int length, int access) {
        this.verbs = verbs;
        this.nativeDispatcher = nativeDispatcher;
        this.memAlloc = memAlloc;
        this.cmd = memAlloc.allocate(12);
        this.valid = true;
        this.pd = (NatIbvPd)pd;
        this.userAddress = address;
        this.bufferCapacity = length;
        this.access = access;
    }

    @Override
    public SVCRegMr execute() throws IOException {
        this.cmd.getBuffer().clear();
        if (!this.pd.isOpen()) {
            throw new IOException("Trying to register memory with closed PD.");
        }
        long objId = this.nativeDispatcher._regMr(this.pd.getObjId(), this.userAddress, this.bufferCapacity, this.access, this.cmd.address(), this.cmd.address() + 4L, this.cmd.address() + 8L);
        if (objId <= 0L) {
            throw new IOException("Memory registration failed with " + objId);
        }
        int lkey = this.cmd.getBuffer().getInt();
        int rkey = this.cmd.getBuffer().getInt();
        int handle = this.cmd.getBuffer().getInt();
        this.mr = new NatIbvMr(objId, null, this.userAddress, this.bufferCapacity, this.access, lkey, rkey, handle);
        return this;
    }

    @Override
    public IbvMr getMr() {
        return this.mr;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public SVCRegMr free() {
        this.cmd.free();
        this.valid = false;
        return this;
    }
}

