/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import com.ibm.disni.util.MemBuf;
import com.ibm.disni.util.MemoryAllocation;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.IbvSendWR;
import com.ibm.disni.verbs.IbvSge;
import com.ibm.disni.verbs.SVCPostSend;
import com.ibm.disni.verbs.impl.NatIbvQP;
import com.ibm.disni.verbs.impl.NatIbvSendWR;
import com.ibm.disni.verbs.impl.NatIbvSge;
import com.ibm.disni.verbs.impl.NativeDispatcher;
import com.ibm.disni.verbs.impl.RdmaVerbsNat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NatPostSendCall
extends SVCPostSend {
    private NativeDispatcher nativeDispatcher;
    private RdmaVerbsNat verbs;
    private MemoryAllocation memAlloc;
    private ArrayList<NatIbvSendWR> wrNatList;
    private ArrayList<NatIbvSge> sgeNatList;
    private NatIbvQP qp;
    private MemBuf cmd;
    private boolean valid;

    public NatPostSendCall(RdmaVerbsNat verbs, NativeDispatcher nativeDispatcher, MemoryAllocation memAlloc, IbvQP qp, List<IbvSendWR> wrList) {
        this.verbs = verbs;
        this.nativeDispatcher = nativeDispatcher;
        this.memAlloc = memAlloc;
        this.wrNatList = new ArrayList(wrList.size());
        this.sgeNatList = new ArrayList();
        this.valid = false;
        this.qp = (NatIbvQP)qp;
        int size = 0;
        for (IbvSendWR sendWR : wrList) {
            size += NatIbvSendWR.CSIZE;
            size += sendWR.getSg_list().size() * NatIbvSge.CSIZE;
        }
        this.cmd = memAlloc.allocate(size);
        this.setWrList(wrList);
    }

    private void setWrList(List<IbvSendWR> wrList) {
        this.wrNatList.clear();
        this.sgeNatList.clear();
        this.cmd.getBuffer().clear();
        long sgeOffset = wrList.size() * NatIbvSendWR.CSIZE;
        long wrOffset = NatIbvSendWR.CSIZE;
        for (IbvSendWR sendWR : wrList) {
            LinkedList<IbvSge> sg_list = new LinkedList<IbvSge>();
            for (IbvSge sge : sendWR.getSg_list()) {
                NatIbvSge natSge = new NatIbvSge(this, sge);
                sg_list.add(natSge);
                this.sgeNatList.add(natSge);
            }
            NatIbvSendWR.NatRdma natRdma = new NatIbvSendWR.NatRdma(sendWR.getRdma(), this);
            NatIbvSendWR natSendWR = new NatIbvSendWR(this, natRdma, sendWR, sg_list);
            natSendWR.setPtr_sge_list(sgeOffset);
            natSendWR.setNext(wrOffset);
            this.wrNatList.add(natSendWR);
            wrOffset += (long)NatIbvSendWR.CSIZE;
            sgeOffset += (long)(sendWR.getSg_list().size() * NatIbvSge.CSIZE);
        }
        for (NatIbvSendWR natWR : this.wrNatList) {
            natWR.shiftAddress(this.cmd.address());
        }
        this.wrNatList.get(this.wrNatList.size() - 1).setNext(0L);
        for (NatIbvSendWR natWR : this.wrNatList) {
            natWR.writeBack(this.cmd.getBuffer());
        }
        for (NatIbvSge sge : this.sgeNatList) {
            sge.writeBack(this.cmd.getBuffer());
        }
        this.valid = true;
    }

    @Override
    public SVCPostSend execute() throws IOException {
        if (!this.qp.isOpen()) {
            throw new IOException("Trying to post send on closed QP");
        }
        this.nativeDispatcher._postSend(this.qp.getObjId(), this.cmd.address());
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public SVCPostSend free() {
        if (this.cmd != null) {
            this.cmd.free();
            this.cmd = null;
        }
        this.valid = false;
        return this;
    }

    @Override
    public SVCPostSend.SendWRMod getWrMod(int index) throws IOException {
        return this.wrNatList.get(index);
    }

    void setWr_id(NatIbvSendWR sendWR, int offset) {
        int position = sendWR.getBufPosition() + offset;
        this.cmd.getBuffer().putLong(position, sendWR.getWr_id());
    }

    public void setRemote_addr(NatIbvSendWR.NatRdma rdma, int offset) {
        int position = rdma.getBufPosition() + offset;
        this.cmd.getBuffer().putLong(position, rdma.getRemote_addr());
    }

    public void setRkey(NatIbvSendWR.NatRdma rdma, int offset) {
        int position = rdma.getBufPosition() + offset;
        this.cmd.getBuffer().putInt(position, rdma.getRkey());
    }

    public void setReserved(NatIbvSendWR.NatRdma rdma, int offset) {
        int position = rdma.getBufPosition() + offset;
        this.cmd.getBuffer().putInt(position, rdma.getReserved());
    }

    public void setAddr(NatIbvSge sge, int offset) {
        int position = sge.getBufPosition() + offset;
        this.cmd.getBuffer().putLong(position, sge.getAddr());
    }

    public void setLength(NatIbvSge sge, int offset) {
        int position = sge.getBufPosition() + offset;
        this.cmd.getBuffer().putInt(position, sge.getLength());
    }

    public void setLkey(NatIbvSge sge, int offset) {
        int position = sge.getBufPosition() + offset;
        this.cmd.getBuffer().putInt(position, sge.getLkey());
    }

    void setSend_flags(NatIbvSendWR sendWR, int offset) {
        int position = sendWR.getBufPosition() + offset;
        this.cmd.getBuffer().putInt(position, sendWR.getSend_flags());
    }
}

