/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import com.ibm.disni.util.MemBuf;
import com.ibm.disni.util.MemoryAllocation;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.IbvRecvWR;
import com.ibm.disni.verbs.IbvSge;
import com.ibm.disni.verbs.SVCPostRecv;
import com.ibm.disni.verbs.impl.NatIbvQP;
import com.ibm.disni.verbs.impl.NatIbvRecvWR;
import com.ibm.disni.verbs.impl.NatIbvSge;
import com.ibm.disni.verbs.impl.NativeDispatcher;
import com.ibm.disni.verbs.impl.RdmaVerbsNat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NatPostRecvCall
extends SVCPostRecv {
    private NativeDispatcher nativeDispatcher;
    private RdmaVerbsNat verbs;
    private MemoryAllocation memAlloc;
    private NatIbvQP qp;
    private ArrayList<NatIbvRecvWR> wrNatList;
    private ArrayList<IbvSge> sgeNatList;
    private MemBuf cmd;
    private boolean valid;

    public NatPostRecvCall(RdmaVerbsNat verbs, NativeDispatcher nativeDispatcher, MemoryAllocation memAlloc, IbvQP qp, List<IbvRecvWR> wrList) {
        this.verbs = verbs;
        this.nativeDispatcher = nativeDispatcher;
        this.memAlloc = memAlloc;
        this.qp = (NatIbvQP)qp;
        this.wrNatList = new ArrayList(wrList.size());
        this.sgeNatList = new ArrayList();
        this.valid = false;
        int size = 0;
        for (IbvRecvWR recvWR : wrList) {
            size += NatIbvRecvWR.CSIZE;
            if (recvWR.getNum_sge() <= 0) continue;
            size += recvWR.getSg_list().size() * NatIbvSge.CSIZE;
        }
        this.cmd = memAlloc.allocate(size);
        this.setWrList(wrList);
    }

    private void setWrList(List<IbvRecvWR> wrList) {
        this.wrNatList.clear();
        this.sgeNatList.clear();
        this.cmd.getBuffer().clear();
        long sgeOffset = wrList.size() * NatIbvRecvWR.CSIZE;
        long wrOffset = NatIbvRecvWR.CSIZE;
        for (IbvRecvWR recvWR : wrList) {
            NatIbvRecvWR natRecvWR = new NatIbvRecvWR(recvWR);
            natRecvWR.setNext(wrOffset);
            this.wrNatList.add(natRecvWR);
            wrOffset += (long)NatIbvRecvWR.CSIZE;
            if (recvWR.getNum_sge() <= 0) continue;
            natRecvWR.setPtr_sge_list(sgeOffset);
            this.sgeNatList.addAll(recvWR.getSg_list());
            sgeOffset += (long)(recvWR.getSg_list().size() * NatIbvSge.CSIZE);
        }
        for (NatIbvRecvWR natWR : this.wrNatList) {
            natWR.shiftAddress(this.cmd.address());
        }
        this.wrNatList.get(this.wrNatList.size() - 1).setNext(0L);
        for (NatIbvRecvWR natWR : this.wrNatList) {
            natWR.writeBack(this.cmd.getBuffer());
        }
        for (IbvSge sge : this.sgeNatList) {
            this.cmd.getBuffer().putLong(sge.getAddr());
            this.cmd.getBuffer().putInt(sge.getLength());
            this.cmd.getBuffer().putInt(sge.getLkey());
        }
        this.valid = true;
    }

    @Override
    public SVCPostRecv execute() throws IOException {
        if (!this.qp.isOpen()) {
            throw new IOException("Trying to post receive on closed QP");
        }
        this.nativeDispatcher._postRecv(this.qp.getObjId(), this.cmd.address());
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public SVCPostRecv free() {
        if (this.cmd != null) {
            this.cmd.free();
            this.cmd = null;
        }
        this.valid = false;
        return this;
    }

    @Override
    public SVCPostRecv.RecvWRMod getWrMod(int index) throws IOException {
        return this.wrNatList.get(index);
    }
}

