/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import com.ibm.disni.util.MemBuf;
import com.ibm.disni.util.MemoryAllocation;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.SVCPollCq;
import com.ibm.disni.verbs.impl.NatIbvCQ;
import com.ibm.disni.verbs.impl.NativeDispatcher;
import com.ibm.disni.verbs.impl.RdmaVerbsNat;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NatPollCqCall
extends SVCPollCq {
    private NativeDispatcher nativeDispatcher;
    private RdmaVerbsNat verbs;
    private MemoryAllocation memAlloc;
    private NatIbvCQ cq;
    private IbvWC[] wcList;
    private int ne;
    private MemBuf cmd;
    private int csize;
    private int result;
    private boolean valid;

    public NatPollCqCall(RdmaVerbsNat verbs, NativeDispatcher nativeDispatcher, MemoryAllocation memAlloc, IbvCQ cq, IbvWC[] wcList, int ne) {
        this.verbs = verbs;
        this.nativeDispatcher = nativeDispatcher;
        this.memAlloc = memAlloc;
        this.valid = false;
        this.cq = (NatIbvCQ)cq;
        this.wcList = wcList;
        this.ne = ne;
        this.csize = wcList.length * IbvWC.CSIZE;
        this.cmd = memAlloc.allocate(this.csize);
        this.valid = true;
    }

    private void update(IbvWC wc, ByteBuffer buffer) {
        int initialPos = buffer.position();
        wc.setWr_id(buffer.getLong());
        wc.setStatus(buffer.getInt());
        wc.setOpcode(buffer.getInt());
        if (wc.getStatus() == IbvWC.IbvWcStatus.IBV_WC_SUCCESS.ordinal()) {
            wc.setVendor_err(buffer.getInt());
            wc.setByte_len(buffer.getInt());
            wc.setImm_data(buffer.getInt());
            wc.setQp_num(buffer.getInt());
            wc.setSrc_qp(buffer.getInt());
            wc.setWc_flags(buffer.getInt());
            wc.setPkey_index(buffer.getShort());
            wc.setSlid(buffer.getShort());
            wc.setSl(buffer.get());
            wc.setDlid_path_bits(buffer.get());
        }
        int newPosition = initialPos + IbvWC.CSIZE;
        buffer.position(newPosition);
    }

    @Override
    public SVCPollCq execute() throws IOException {
        this.result = 0;
        if (!this.cq.isOpen()) {
            throw new IOException("Trying to poll closed CQ.");
        }
        this.result = this.nativeDispatcher._pollCQ(this.cq.getObjId(), this.ne, this.cmd.address());
        if (this.result < 0) {
            throw new IOException("Polling CQ failed");
        }
        if (this.result > 0) {
            this.cmd.getBuffer().clear();
            for (int i = 0; i < this.result; ++i) {
                this.update(this.wcList[i], this.cmd.getBuffer());
            }
        }
        return this;
    }

    @Override
    public int getPolls() {
        return this.result;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public SVCPollCq free() {
        if (this.cmd != null) {
            this.cmd.free();
            this.cmd = null;
        }
        this.valid = false;
        return this;
    }
}

