/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import com.ibm.disni.verbs.IbvSendWR;
import com.ibm.disni.verbs.IbvSge;
import com.ibm.disni.verbs.SVCPostSend;
import com.ibm.disni.verbs.impl.NatPostSendCall;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class NatIbvSendWR
extends IbvSendWR
implements SVCPostSend.SendWRMod {
    public static int CSIZE = 72;
    public static int WRID_OFFSET = 0;
    public static int SENDFLAGS_OFFSET = 32;
    public static int REMOTEADDR_OFFSET = 40;
    public static int RKEY_OFFSET = 48;
    private NatPostSendCall postSendCall;
    private int bufPosition;
    private long next;
    private long ptr_sge_list;
    private NatRdma natRdma;

    public NatIbvSendWR(NatPostSendCall postSendCall, NatRdma natRdma, IbvSendWR sendWR, LinkedList<IbvSge> sg_list) {
        super(natRdma, null, null, sg_list);
        this.natRdma = natRdma;
        this.next = 0L;
        this.ptr_sge_list = 0L;
        this.wr_id = sendWR.getWr_id();
        this.num_sge = sendWR.getNum_sge();
        this.opcode = sendWR.getOpcode();
        this.send_flags = sendWR.getSend_flags();
        this.imm_data = sendWR.getImm_data();
        this.postSendCall = postSendCall;
        this.bufPosition = 0;
    }

    public void writeBack(ByteBuffer buffer) {
        int initialPos = this.bufPosition = buffer.position();
        buffer.putLong(this.wr_id);
        buffer.putLong(this.next);
        buffer.putLong(this.ptr_sge_list);
        buffer.putInt(this.num_sge);
        buffer.putInt(this.opcode);
        buffer.putInt(this.send_flags);
        buffer.putInt(this.imm_data);
        buffer.position(initialPos + REMOTEADDR_OFFSET);
        this.natRdma.writeBack(buffer);
        int newPos = initialPos + CSIZE;
        buffer.position(newPos);
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long next) {
        this.next = next;
    }

    public int getCsize() {
        return CSIZE;
    }

    public long getPtr_sge_list() {
        return this.ptr_sge_list;
    }

    public void setPtr_sge_list(long ptr_sge_list) {
        this.ptr_sge_list = ptr_sge_list;
    }

    public void shiftAddress(long address) {
        this.next += address;
        this.ptr_sge_list += address;
    }

    public int getBufPosition() {
        return this.bufPosition;
    }

    @Override
    public void setWr_id(long wr_id) {
        super.setWr_id(wr_id);
        this.postSendCall.setWr_id(this, WRID_OFFSET);
    }

    @Override
    public void setSend_flags(int send_flags) {
        super.setSend_flags(send_flags);
        this.postSendCall.setSend_flags(this, SENDFLAGS_OFFSET);
    }

    @Override
    public SVCPostSend.RdmaMod getRdmaMod() {
        return (SVCPostSend.RdmaMod)((Object)this.rdma);
    }

    @Override
    public SVCPostSend.SgeMod getSgeMod(int index) {
        return (SVCPostSend.SgeMod)this.sg_list.get(index);
    }

    public static class NatRdma
    extends IbvSendWR.Rdma
    implements SVCPostSend.RdmaMod {
        private NatPostSendCall postSendCall;
        private int bufPosition;

        public NatRdma(IbvSendWR.Rdma rdma, NatPostSendCall postSendCall) {
            this.remote_addr = rdma.getRemote_addr();
            this.reserved = rdma.getReserved();
            this.rkey = rdma.getRkey();
            this.postSendCall = postSendCall;
        }

        @Override
        public void setRemote_addr(long remote_addr) {
            super.setRemote_addr(remote_addr);
            this.postSendCall.setRemote_addr(this, 0);
        }

        @Override
        public void setRkey(int rkey) {
            super.setRkey(rkey);
            this.postSendCall.setRkey(this, 8);
        }

        @Override
        public void setReserved(int reserved) {
            super.setReserved(reserved);
            this.postSendCall.setReserved(this, 12);
        }

        public void writeBack(ByteBuffer buffer) {
            this.bufPosition = buffer.position();
            buffer.putLong(this.getRemote_addr());
            buffer.putInt(this.getRkey());
            buffer.putInt(this.getReserved());
        }

        public int getBufPosition() {
            return this.bufPosition;
        }
    }
}

