/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs.impl;

import com.ibm.disni.verbs.IbvCompChannel;
import com.ibm.disni.verbs.SVCGetCqEvent;
import com.ibm.disni.verbs.impl.NatIbvCompChannel;
import com.ibm.disni.verbs.impl.NativeDispatcher;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class NatGetCqCall
extends SVCGetCqEvent {
    private NativeDispatcher nativeDispatcher;
    private LinkedBlockingQueue<NatGetCqCall> getCqList;
    private NatIbvCompChannel compChannel;
    private boolean valid;
    private int timeout;

    public NatGetCqCall(LinkedBlockingQueue<NatGetCqCall> getCqList, NativeDispatcher nativeDispatcher, int timeout) {
        this.getCqList = getCqList;
        this.nativeDispatcher = nativeDispatcher;
        this.valid = false;
        this.timeout = timeout;
    }

    public void set(IbvCompChannel compChannel) {
        this.compChannel = (NatIbvCompChannel)compChannel;
        this.valid = true;
    }

    @Override
    public SVCGetCqEvent execute() throws IOException {
        if (!this.compChannel.isOpen()) {
            throw new IOException("Trying to get CQ event on closed completion channel.");
        }
        int ret = this.nativeDispatcher._getCqEvent(this.compChannel.getObjId(), this.timeout);
        if (ret != 0) {
            throw new IOException("GetCQEvent failed");
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public SVCGetCqEvent free() {
        this.valid = false;
        this.getCqList.add(this);
        return this;
    }
}

