/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs;

import com.ibm.disni.verbs.IbvSge;
import java.util.LinkedList;

public class IbvSendWR {
    public static final int IBV_WR_RDMA_WRITE = 0;
    public static final int IBV_WR_RDMA_WRITE_WITH_IMM = 1;
    public static final int IBV_WR_SEND = 2;
    public static final int IBV_WR_SEND_WITH_IMM = 3;
    public static final int IBV_WR_RDMA_READ = 4;
    public static final int IBV_WR_ATOMIC_CMP_AND_SWP = 5;
    public static final int IBV_WR_ATOMIC_FETCH_AND_ADD = 6;
    public static int IBV_SEND_FENCE = 1;
    public static int IBV_SEND_SIGNALED = 2;
    public static int IBV_SEND_SOLICITED = 4;
    public static int IBV_SEND_INLINE = 8;
    protected long wr_id;
    protected LinkedList<IbvSge> sg_list;
    protected int num_sge;
    protected int opcode;
    protected int send_flags;
    protected int imm_data;
    protected Rdma rdma;
    protected Atomic atomic;
    protected Ud ud;

    public IbvSendWR() {
        this.rdma = new Rdma();
        this.atomic = new Atomic();
        this.ud = new Ud();
        this.sg_list = new LinkedList();
    }

    protected IbvSendWR(Rdma rdma, Atomic atomic, Ud ud, LinkedList<IbvSge> sg_list) {
        this.rdma = rdma;
        this.atomic = atomic;
        this.ud = ud;
        this.sg_list = sg_list;
    }

    public long getWr_id() {
        return this.wr_id;
    }

    public void setWr_id(long wr_id) {
        this.wr_id = wr_id;
    }

    public LinkedList<IbvSge> getSg_list() {
        return this.sg_list;
    }

    public IbvSge getSge(int index) {
        return this.sg_list.get(index);
    }

    public void setSg_list(LinkedList<IbvSge> sg_list) {
        this.sg_list.clear();
        this.sg_list.addAll(sg_list);
        this.num_sge = sg_list.size();
    }

    public int getNum_sge() {
        return this.num_sge;
    }

    public void setNum_sge(int num_sge) {
        this.num_sge = num_sge;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public int getSend_flags() {
        return this.send_flags;
    }

    public void setSend_flags(int send_flags) {
        this.send_flags = send_flags;
    }

    public int getImm_data() {
        return this.imm_data;
    }

    public void setImm_data(int imm_data) {
        this.imm_data = imm_data;
    }

    public Rdma getRdma() {
        return this.rdma;
    }

    public Atomic getAtomic() {
        return this.atomic;
    }

    public Ud getUd() {
        return this.ud;
    }

    public static class Ud {
        protected int ah;
        protected int remote_qpn;
        protected int remote_qkey;
        protected int reserved;

        public int getAh() {
            return this.ah;
        }

        public void setAh(int ah) {
            this.ah = ah;
        }

        public int getRemote_qpn() {
            return this.remote_qpn;
        }

        public void setRemote_qpn(int remote_qpn) {
            this.remote_qpn = remote_qpn;
        }

        public int getRemote_qkey() {
            return this.remote_qkey;
        }

        public void setRemote_qkey(int remote_qkey) {
            this.remote_qkey = remote_qkey;
        }

        public int getReserved() {
            return this.reserved;
        }

        public void setReserved(int reserved) {
            this.reserved = reserved;
        }

        public String getClassName() {
            return Ud.class.getCanonicalName();
        }
    }

    public static class Atomic {
        protected long remote_addr;
        protected long compare_add;
        protected long swap;
        protected int rkey;
        protected int reserved;

        public long getRemote_addr() {
            return this.remote_addr;
        }

        public void setRemote_addr(long remote_addr) {
            this.remote_addr = remote_addr;
        }

        public long getCompare_add() {
            return this.compare_add;
        }

        public void setCompare_add(long compare_add) {
            this.compare_add = compare_add;
        }

        public long getSwap() {
            return this.swap;
        }

        public void setSwap(long swap) {
            this.swap = swap;
        }

        public int getRkey() {
            return this.rkey;
        }

        public void setRkey(int rkey) {
            this.rkey = rkey;
        }

        public int getReserved() {
            return this.reserved;
        }

        public void setReserved(int reserved) {
            this.reserved = reserved;
        }

        public String getClassName() {
            return Atomic.class.getCanonicalName();
        }
    }

    public static class Rdma {
        protected long remote_addr;
        protected int rkey;
        protected int reserved;

        public long getRemote_addr() {
            return this.remote_addr;
        }

        public void setRemote_addr(long remote_addr) {
            this.remote_addr = remote_addr;
        }

        public int getRkey() {
            return this.rkey;
        }

        public void setRkey(int rkey) {
            this.rkey = rkey;
        }

        public int getReserved() {
            return this.reserved;
        }

        public void setReserved(int reserved) {
            this.reserved = reserved;
        }

        public String getClassName() {
            return Rdma.class.getCanonicalName();
        }
    }

    public static enum IbvWrOcode {
        IBV_WR_RDMA_WRITE,
        IBV_WR_RDMA_WRITE_WITH_IMM,
        IBV_WR_SEND,
        IBV_WR_SEND_WITH_IMM,
        IBV_WR_RDMA_READ,
        IBV_WR_ATOMIC_CMP_AND_SWP,
        IBV_WR_ATOMIC_FETCH_AND_ADD;

    }
}

