/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.verbs;

import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvCompChannel;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.RdmaVerbs;
import java.io.IOException;

public class IbvContext {
    private RdmaVerbs verbs = RdmaVerbs.open();
    protected int cmd_fd;
    protected volatile boolean isOpen;
    protected int numCompVectors;
    public static int IBV_ODP_SUPPORT_SEND = 1;
    public static int IBV_ODP_SUPPORT_RECV = 2;
    public static int IBV_ODP_SUPPORT_WRITE = 4;
    public static int IBV_ODP_SUPPORT_READ = 8;
    public static int IBV_ODP_SUPPORT_ATOMIC = 16;

    protected IbvContext(int cmd_fd, int numCompVectors) throws IOException {
        this.cmd_fd = cmd_fd;
        this.isOpen = true;
        this.numCompVectors = numCompVectors;
    }

    public int getCmd_fd() throws IOException {
        return this.cmd_fd;
    }

    public int getNumCompVectors() throws IOException {
        return this.numCompVectors;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() {
        this.isOpen = false;
    }

    public IbvPd allocPd() throws IOException {
        return this.verbs.allocPd(this);
    }

    public IbvCompChannel createCompChannel() throws IOException {
        return this.verbs.createCompChannel(this);
    }

    public IbvCQ createCQ(IbvCompChannel compChannel, int ncqe, int comp_vector) throws IOException {
        return this.verbs.createCQ(this, compChannel, ncqe, comp_vector);
    }

    public int queryOdpSupport() throws IOException {
        return this.verbs.queryOdpSupport(this);
    }
}

