/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.util;

import com.ibm.disni.util.EndianUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NetUtils {
    private static final boolean nativeIsNetwork = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private NetUtils() {
    }

    public static int getIntIPFromName(String name) throws UnknownHostException {
        InetAddress localHost = InetAddress.getByName(name);
        byte[] addr = localHost.getAddress();
        ByteBuffer buffer = ByteBuffer.wrap(addr);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.clear();
        return buffer.getInt();
    }

    public static int getIntIPFromInetAddress(InetAddress localHost) throws UnknownHostException {
        if (localHost == null) {
            throw new UnknownHostException("Address not defined");
        }
        byte[] addr = localHost.getAddress();
        ByteBuffer buffer = ByteBuffer.wrap(addr);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.clear();
        return buffer.getInt();
    }

    public static InetAddress getInetAddressFromIntIP(int intIP) throws UnknownHostException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(intIP);
        buffer.clear();
        byte[] addr = new byte[4];
        buffer.get(addr);
        InetAddress address = InetAddress.getByAddress(addr);
        return address;
    }

    public static short hostToNetworkByteOrder(short x) {
        if (nativeIsNetwork) {
            return x;
        }
        return EndianUtils.swap(x);
    }

    public static char hostToNetworkByteOrder(char x) {
        if (nativeIsNetwork) {
            return x;
        }
        return EndianUtils.swap(x);
    }

    public static int hostToNetworkByteOrder(int x) {
        if (nativeIsNetwork) {
            return x;
        }
        return EndianUtils.swap(x);
    }

    public static long hostToNetworkByteOrder(long x) {
        if (nativeIsNetwork) {
            return x;
        }
        return EndianUtils.swap(x);
    }

    public static short networkToHostByteOrder(short x) {
        if (nativeIsNetwork) {
            return x;
        }
        return EndianUtils.swap(x);
    }

    public static char networkToHostByteOrder(char x) {
        if (nativeIsNetwork) {
            return x;
        }
        return EndianUtils.swap(x);
    }

    public static int networkToHostByteOrder(int x) {
        if (nativeIsNetwork) {
            return x;
        }
        return EndianUtils.swap(x);
    }

    public static long networkToHostByteOrder(long x) {
        if (nativeIsNetwork) {
            return x;
        }
        return EndianUtils.swap(x);
    }

    public static int getIntIPFromInetAddress(String string) {
        return 0;
    }
}

