/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni.util;

import com.ibm.disni.util.MemBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentSkipListMap;

public class MemoryAllocation {
    private static MemoryAllocation instance = null;
    private ConcurrentSkipListMap<Integer, MemBuf> table = new ConcurrentSkipListMap();
    private static final int MIN_BLOCK_SIZE = 64;

    public static synchronized MemoryAllocation getInstance() {
        if (instance == null) {
            instance = new MemoryAllocation();
        }
        return instance;
    }

    private MemoryAllocation() {
    }

    private int roundUpSize(int size) {
        if (size < 64) {
            size = 64;
        } else {
            --size;
            size |= size >> 1;
            size |= size >> 2;
            size |= size >> 4;
            size |= size >> 8;
            size |= size >> 16;
            ++size;
        }
        return size;
    }

    public MemBuf allocate(int size) {
        MemBuf buf = this.table.remove(size = this.roundUpSize(size));
        if (buf == null) {
            return this._allocate(size);
        }
        return buf;
    }

    void free(MemBuf memBuf) {
        memBuf.getBuffer().clear();
        this.table.putIfAbsent(memBuf.size(), memBuf);
    }

    private MemBuf _allocate(int size) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.order(ByteOrder.nativeOrder());
        return new MemBuf(buffer, this);
    }
}

