/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.RdmaEndpointGroup;
import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.RdmaCmEvent;
import com.ibm.disni.verbs.RdmaCmId;
import com.ibm.disni.verbs.SVCDeregMr;
import com.ibm.disni.verbs.SVCRegMr;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;

public class RdmaServerEndpoint<C extends RdmaEndpoint> {
    private static final Logger logger = DiSNILogger.getLogger();
    private static int CONN_STATE_INITIALIZED = 0;
    private static int CONN_STATE_READY_FOR_ACCEPT = 1;
    private static int CONN_STATE_CLOSED = 2;
    protected int endpointId;
    protected IbvPd pd;
    protected RdmaCmId idPriv;
    private LinkedBlockingDeque<C> requested;
    private RdmaEndpointGroup<C> group;
    protected int access;
    private boolean isClosed;
    private int connState;

    public RdmaServerEndpoint(RdmaEndpointGroup<C> endpointGroup, RdmaCmId idPriv) {
        this.endpointId = endpointGroup.getNextId();
        this.group = endpointGroup;
        this.idPriv = idPriv;
        this.connState = CONN_STATE_INITIALIZED;
        this.requested = new LinkedBlockingDeque();
        this.isClosed = false;
        this.access = IbvMr.IBV_ACCESS_LOCAL_WRITE | IbvMr.IBV_ACCESS_REMOTE_WRITE | IbvMr.IBV_ACCESS_REMOTE_READ;
        logger.info("new server endpoint, id " + this.endpointId);
    }

    public synchronized RdmaServerEndpoint<C> bind(SocketAddress src, int backlog) throws Exception {
        if (this.connState != CONN_STATE_INITIALIZED) {
            throw new IOException("endpoint has to be disconnected for bind");
        }
        this.connState = CONN_STATE_READY_FOR_ACCEPT;
        this.idPriv.bindAddr(src);
        this.idPriv.listen(backlog);
        this.pd = this.group.createProtectionDomainRaw(this);
        logger.info("PD value " + this.pd.getHandle());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C accept() throws IOException {
        try {
            RdmaServerEndpoint rdmaServerEndpoint = this;
            synchronized (rdmaServerEndpoint) {
                if (this.connState != CONN_STATE_READY_FOR_ACCEPT) {
                    throw new IOException("bind needs to be called before accept (1), current state =" + this.connState);
                }
                logger.info("starting accept");
                if (this.requested.peek() == null) {
                    this.wait();
                }
            }
            RdmaEndpoint endpoint = (RdmaEndpoint)this.requested.poll();
            logger.info("connect request received");
            endpoint.accept();
            return (C)endpoint;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public synchronized void dispatchCmEvent(RdmaCmEvent cmEvent) throws IOException {
        try {
            int eventType = cmEvent.getEvent();
            if (eventType == RdmaCmEvent.EventType.RDMA_CM_EVENT_CONNECT_REQUEST.ordinal()) {
                RdmaCmId connId = cmEvent.getConnIdPriv();
                C ep = this.group.createEndpoint(connId);
                ((RdmaEndpoint)ep).dispatchCmEvent(cmEvent);
                this.requested.add(ep);
                this.notifyAll();
            } else if (eventType == RdmaCmEvent.EventType.RDMA_CM_EVENT_DISCONNECTED.ordinal()) {
                this.connState = CONN_STATE_CLOSED;
                this.notifyAll();
            } else {
                logger.info("got event type + UNKNOWN, serverAddress " + this.getSrcAddr());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public synchronized void close() throws IOException, InterruptedException {
        if (this.isClosed) {
            return;
        }
        logger.info("closing server endpoint");
        this.idPriv.destroyId();
        this.group.unregisterServerEp(this);
        this.isClosed = true;
    }

    public synchronized boolean isBound() {
        return this.connState == CONN_STATE_READY_FOR_ACCEPT;
    }

    public synchronized boolean isClosed() {
        return this.connState == CONN_STATE_CLOSED;
    }

    public SocketAddress getSrcAddr() throws Exception {
        return this.idPriv.getSource();
    }

    public RdmaCmId getIdPriv() {
        return this.idPriv;
    }

    public int getEndpointId() {
        return this.endpointId;
    }

    public IbvPd getPd() {
        return this.pd;
    }

    public SVCRegMr registerMemory(ByteBuffer buffer) throws IOException {
        return this.pd.regMr(buffer, this.access);
    }

    public void deregisterMemory(IbvMr mr) throws IOException {
        ((SVCDeregMr)mr.deregMr().execute()).free();
    }
}

