/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.RdmaCqProvider;
import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.RdmaEndpointFactory;
import com.ibm.disni.RdmaEndpointGroup;
import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.IbvQPInitAttr;
import com.ibm.disni.verbs.RdmaCmId;
import java.io.IOException;
import org.slf4j.Logger;

public class RdmaPassiveEndpointGroup<C extends RdmaEndpoint>
extends RdmaEndpointGroup<C> {
    private static final Logger logger = DiSNILogger.getLogger();
    private int maxWR;
    private int maxSge;
    private int cqSize;

    public RdmaPassiveEndpointGroup<RdmaEndpoint> createDefaultGroup(int timeout, int maxWR, int maxSge, int cqSize) throws IOException {
        RdmaPassiveEndpointGroup<RdmaEndpoint> group = new RdmaPassiveEndpointGroup<RdmaEndpoint>(timeout, maxWR, maxSge, cqSize);
        group.init(new RawEndpointFactory(group));
        return group;
    }

    public RdmaPassiveEndpointGroup(int timeout, int maxWR, int maxSge, int cqSize) throws IOException {
        super(timeout);
        this.maxWR = maxWR;
        this.maxSge = maxSge;
        this.cqSize = cqSize;
        logger.info("passive endpoint group, maxWR " + this.maxWR + ", maxSge " + this.maxSge + ", cqSize " + this.cqSize);
    }

    @Override
    public RdmaCqProvider createCqProvider(C endpoint) throws IOException {
        logger.info("setting up cq processor");
        return new RdmaCqProvider(((RdmaEndpoint)endpoint).getIdPriv().getVerbs(), this.cqSize);
    }

    @Override
    public IbvQP createQpProvider(C endpoint) throws IOException {
        RdmaCqProvider cqProvider = ((RdmaEndpoint)endpoint).getCqProvider();
        IbvCQ cq = cqProvider.getCQ();
        IbvQPInitAttr attr = new IbvQPInitAttr();
        attr.cap().setMax_recv_sge(this.maxSge);
        attr.cap().setMax_recv_wr(this.maxWR);
        attr.cap().setMax_send_sge(this.maxSge);
        attr.cap().setMax_send_wr(this.maxWR);
        attr.setQp_type((byte)2);
        attr.setRecv_cq(cq);
        attr.setSend_cq(cq);
        IbvQP qp = ((RdmaEndpoint)endpoint).getIdPriv().createQP(((RdmaEndpoint)endpoint).getPd(), attr);
        return qp;
    }

    @Override
    public void allocateResources(C endpoint) throws Exception {
        ((RdmaEndpoint)endpoint).allocateResources();
    }

    public int getMaxWR() {
        return this.maxWR;
    }

    public int getMaxSge() {
        return this.maxSge;
    }

    public int getCqSize() {
        return this.cqSize;
    }

    protected class RawEndpointFactory
    implements RdmaEndpointFactory<RdmaEndpoint> {
        RdmaPassiveEndpointGroup<RdmaEndpoint> group;

        public RawEndpointFactory(RdmaPassiveEndpointGroup<RdmaEndpoint> group) {
            this.group = group;
        }

        @Override
        public RdmaEndpoint createEndpoint(RdmaCmId idPriv, boolean serverSide) throws IOException {
            return new RdmaEndpoint(this.group, idPriv, serverSide);
        }
    }
}

