/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.RdmaServerEndpoint;
import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.IbvContext;
import com.ibm.disni.verbs.IbvPd;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;

public class RdmaEndpointProvider {
    private static final Logger logger = DiSNILogger.getLogger();
    private static RdmaEndpointProvider provider = null;
    protected HashMap<Integer, IbvPd> pdMap = new HashMap();

    private RdmaEndpointProvider() throws IOException {
    }

    public static synchronized RdmaEndpointProvider getEndpointProvider() throws IOException {
        if (provider == null) {
            provider = new RdmaEndpointProvider();
        }
        return provider;
    }

    public synchronized IbvPd createProtectionDomain(RdmaEndpoint endpoint) throws IOException {
        IbvContext context = endpoint.getIdPriv().getVerbs();
        return this.createProtectionDomain(context);
    }

    public synchronized IbvPd createProtectionDomain(RdmaServerEndpoint<?> endpoint) throws IOException {
        IbvContext context = endpoint.getIdPriv().getVerbs();
        return this.createProtectionDomain(context);
    }

    public synchronized IbvPd createProtectionDomain(IbvContext context) throws IOException {
        if (context != null) {
            IbvPd pd = null;
            int key = context.getCmd_fd();
            if (!this.pdMap.containsKey(key)) {
                pd = context.allocPd();
                this.pdMap.put(context.getCmd_fd(), pd);
            }
            pd = this.pdMap.get(context.getCmd_fd());
            logger.info("setting up protection domain, context " + context.getCmd_fd() + ", pd " + pd.getHandle());
            return pd;
        }
        throw new IOException("setting up protection domain, no context found");
    }
}

