/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.RdmaCmProcessor;
import com.ibm.disni.RdmaCqProvider;
import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.RdmaEndpointFactory;
import com.ibm.disni.RdmaEndpointProvider;
import com.ibm.disni.RdmaServerEndpoint;
import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.RdmaCmEvent;
import com.ibm.disni.verbs.RdmaCmId;
import com.ibm.disni.verbs.RdmaConnParam;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public abstract class RdmaEndpointGroup<C extends RdmaEndpoint> {
    private static final Logger logger = DiSNILogger.getLogger();
    private static int idCounter = 0;
    protected RdmaEndpointProvider endpointProvider = RdmaEndpointProvider.getEndpointProvider();
    protected RdmaCmProcessor cmProcessor;
    protected HashMap<RdmaCmId, RdmaServerEndpoint<C>> serverEndpointMap = new HashMap();
    protected HashMap<RdmaCmId, C> clientEndpointMap = new HashMap();
    protected AtomicBoolean closed;
    protected RdmaEndpointFactory<C> factory;
    protected RdmaConnParam connParam;

    public abstract RdmaCqProvider createCqProvider(C var1) throws IOException;

    public abstract IbvQP createQpProvider(C var1) throws IOException;

    public abstract void allocateResources(C var1) throws Exception;

    public RdmaEndpointGroup(int timeout) throws IOException {
        this.cmProcessor = new RdmaCmProcessor(this, timeout);
        this.closed = new AtomicBoolean(true);
        this.connParam = new RdmaConnParam();
    }

    public void init(RdmaEndpointFactory<C> factory) {
        this.closed.set(false);
        this.factory = factory;
        this.cmProcessor.start();
    }

    public synchronized IbvPd createProtectionDomain(C endpoint) throws IOException {
        return this.endpointProvider.createProtectionDomain((RdmaEndpoint)endpoint);
    }

    public synchronized IbvPd createProtectionDomain(RdmaServerEndpoint<C> endpoint) throws IOException {
        return this.endpointProvider.createProtectionDomain(endpoint);
    }

    public final synchronized RdmaServerEndpoint<C> createServerEndpoint() throws IOException {
        RdmaCmId idPriv = this.cmProcessor.createId((short)262);
        RdmaServerEndpoint ep = new RdmaServerEndpoint(this, idPriv);
        this.serverEndpointMap.put(idPriv, ep);
        return ep;
    }

    public final synchronized C createEndpoint() throws IOException {
        RdmaCmId idPriv = this.cmProcessor.createId((short)262);
        C ep = this.factory.createEndpoint(idPriv, false);
        this.clientEndpointMap.put(idPriv, ep);
        return ep;
    }

    protected final synchronized C createEndpoint(RdmaCmId idPriv) throws IOException {
        C ep = this.factory.createEndpoint(idPriv, true);
        this.clientEndpointMap.put(idPriv, ep);
        return ep;
    }

    public final void dispatchCmEvent(RdmaCmEvent cmEvent) {
        try {
            if (this.closed.get()) {
                return;
            }
            RdmaCmId idPriv = cmEvent.getListenIdPriv();
            RdmaCmId clientID = cmEvent.getConnIdPriv();
            int event = cmEvent.getEvent();
            if (event == RdmaCmEvent.EventType.RDMA_CM_EVENT_CONNECT_REQUEST.ordinal()) {
                if (idPriv != null && this.serverEndpointMap.containsKey(idPriv)) {
                    this.serverEndpointMap.get(idPriv).dispatchCmEvent(cmEvent);
                }
            } else if (event == RdmaCmEvent.EventType.RDMA_CM_EVENT_ESTABLISHED.ordinal()) {
                if (clientID != null && this.clientEndpointMap.containsKey(clientID)) {
                    ((RdmaEndpoint)this.clientEndpointMap.get(clientID)).dispatchCmEvent(cmEvent);
                } else {
                    logger.info("have no client endpoint to this event");
                }
            } else if (event == RdmaCmEvent.EventType.RDMA_CM_EVENT_ADDR_RESOLVED.ordinal()) {
                if (clientID != null && this.clientEndpointMap.containsKey(clientID)) {
                    ((RdmaEndpoint)this.clientEndpointMap.get(clientID)).dispatchCmEvent(cmEvent);
                } else {
                    logger.info("have no client endpoint to this event");
                }
            } else if (event == RdmaCmEvent.EventType.RDMA_CM_EVENT_ROUTE_RESOLVED.ordinal()) {
                if (clientID != null && this.clientEndpointMap.containsKey(clientID)) {
                    RdmaEndpoint ep = (RdmaEndpoint)this.clientEndpointMap.get(clientID);
                    ep.dispatchCmEvent(cmEvent);
                } else {
                    logger.info("have no client endpoint to this event");
                }
            } else if (event == RdmaCmEvent.EventType.RDMA_CM_EVENT_DISCONNECTED.ordinal()) {
                if (clientID != null && this.clientEndpointMap.containsKey(clientID)) {
                    ((RdmaEndpoint)this.clientEndpointMap.get(clientID)).dispatchCmEvent(cmEvent);
                }
                if (idPriv != null && this.serverEndpointMap.containsKey(idPriv)) {
                    this.serverEndpointMap.get(idPriv).dispatchCmEvent(cmEvent);
                }
            } else {
                if (clientID != null && this.clientEndpointMap.containsKey(clientID)) {
                    ((RdmaEndpoint)this.clientEndpointMap.get(clientID)).dispatchCmEvent(cmEvent);
                }
                if (idPriv != null && this.serverEndpointMap.containsKey(idPriv)) {
                    this.serverEndpointMap.get(idPriv).dispatchCmEvent(cmEvent);
                }
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    public RdmaConnParam getConnParam() {
        return this.connParam;
    }

    public synchronized void close() throws IOException, InterruptedException {
        logger.info("shutting down group");
        if (this.closed.get()) {
            return;
        }
        LinkedList<RdmaEndpoint> clientEps = new LinkedList<RdmaEndpoint>();
        for (RdmaEndpoint ep : this.clientEndpointMap.values()) {
            clientEps.add(ep);
        }
        for (RdmaEndpoint ep : clientEps) {
            ep.close();
        }
        LinkedList<RdmaServerEndpoint<C>> serverEps = new LinkedList<RdmaServerEndpoint<C>>();
        for (RdmaServerEndpoint<C> rdmaServerEndpoint : this.serverEndpointMap.values()) {
            serverEps.add(rdmaServerEndpoint);
        }
        for (RdmaServerEndpoint<Object> rdmaServerEndpoint : serverEps) {
            rdmaServerEndpoint.close();
        }
        this.cmProcessor.close();
        this.closed.set(true);
        logger.info("shutting down group done");
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public synchronized int getNextId() {
        int id = idCounter++;
        return id;
    }

    synchronized IbvPd createProtectionDomainRaw(RdmaEndpoint endpoint) throws IOException {
        return this.createProtectionDomain((RdmaEndpoint)this.clientEndpointMap.get(endpoint.getIdPriv()));
    }

    synchronized IbvPd createProtectionDomainRaw(RdmaServerEndpoint<C> endpoint) throws IOException {
        return this.createProtectionDomain(this.serverEndpointMap.get(endpoint.getIdPriv()));
    }

    synchronized RdmaCqProvider createCqProviderRaw(RdmaEndpoint endpoint) throws IOException {
        return this.createCqProvider((RdmaEndpoint)this.clientEndpointMap.get(endpoint.getIdPriv()));
    }

    synchronized IbvQP createQpProviderRaw(RdmaEndpoint endpoint) throws IOException {
        return this.createQpProvider((RdmaEndpoint)this.clientEndpointMap.get(endpoint.getIdPriv()));
    }

    synchronized void allocateResourcesRaw(RdmaEndpoint endpoint) throws Exception {
        this.allocateResources((RdmaEndpoint)this.clientEndpointMap.get(endpoint.getIdPriv()));
    }

    synchronized void unregisterClientEp(RdmaEndpoint endpoint) throws IOException {
        if (this.clientEndpointMap.containsKey(endpoint.getIdPriv())) {
            this.clientEndpointMap.remove(endpoint.getIdPriv());
        }
    }

    synchronized void unregisterServerEp(RdmaServerEndpoint<C> endpoint) {
        if (this.serverEndpointMap.containsKey(endpoint.getIdPriv())) {
            this.serverEndpointMap.remove(endpoint.getIdPriv());
        }
    }
}

