/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.RdmaCqProvider;
import com.ibm.disni.RdmaEndpointGroup;
import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.IbvMr;
import com.ibm.disni.verbs.IbvPd;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.IbvRecvWR;
import com.ibm.disni.verbs.IbvSendWR;
import com.ibm.disni.verbs.RdmaCmEvent;
import com.ibm.disni.verbs.RdmaCmId;
import com.ibm.disni.verbs.RdmaConnParam;
import com.ibm.disni.verbs.SVCDeregMr;
import com.ibm.disni.verbs.SVCPostRecv;
import com.ibm.disni.verbs.SVCPostSend;
import com.ibm.disni.verbs.SVCRegMr;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;

public class RdmaEndpoint {
    private static final Logger logger = DiSNILogger.getLogger();
    private static int CONN_STATE_INITIALIZED = 0;
    private static int CONN_STATE_ADDR_RESOLVED = 1;
    private static int CONN_STATE_ROUTE_RESOLVED = 2;
    private static int CONN_STATE_RESOURCES_ALLOCATED = 3;
    private static int CONN_STATE_CONNECTED = 4;
    private static int CONN_STATE_CLOSED = 5;
    protected int endpointId;
    protected RdmaEndpointGroup<? extends RdmaEndpoint> group;
    protected RdmaCmId idPriv;
    protected IbvQP qp;
    protected IbvPd pd;
    protected RdmaCqProvider cqProcessor;
    protected int access;
    private int connState;
    private boolean isClosed;
    private boolean isInitialized;
    private boolean serverSide;

    protected RdmaEndpoint(RdmaEndpointGroup<? extends RdmaEndpoint> group, RdmaCmId idPriv, boolean serverSide) throws IOException {
        this.endpointId = group.getNextId();
        this.group = group;
        this.idPriv = idPriv;
        this.access = IbvMr.IBV_ACCESS_LOCAL_WRITE | IbvMr.IBV_ACCESS_REMOTE_WRITE | IbvMr.IBV_ACCESS_REMOTE_READ;
        this.qp = null;
        this.pd = null;
        this.cqProcessor = null;
        this.isInitialized = false;
        this.isClosed = false;
        this.connState = CONN_STATE_INITIALIZED;
        this.serverSide = serverSide;
        logger.info("new client endpoint, id " + this.endpointId + ", idPriv " + idPriv.getPs());
    }

    public synchronized void connect(SocketAddress dst, int timeout) throws Exception {
        if (this.connState != CONN_STATE_INITIALIZED) {
            throw new IOException("endpoint already connected");
        }
        this.idPriv.resolveAddr(null, dst, timeout);
        while (this.connState < CONN_STATE_ADDR_RESOLVED) {
            this.wait();
        }
        if (this.connState != CONN_STATE_ADDR_RESOLVED) {
            throw new IOException("resolve address failed");
        }
        this.idPriv.resolveRoute(timeout);
        while (this.connState < CONN_STATE_ROUTE_RESOLVED) {
            this.wait();
        }
        if (this.connState != CONN_STATE_ROUTE_RESOLVED) {
            throw new IOException("resolve route failed");
        }
        this.group.allocateResourcesRaw(this);
        while (this.connState < CONN_STATE_RESOURCES_ALLOCATED) {
            this.wait();
        }
        if (this.connState != CONN_STATE_RESOURCES_ALLOCATED) {
            throw new IOException("resources allocation failed");
        }
        RdmaConnParam connParam = this.getConnParam();
        this.idPriv.connect(connParam);
        while (this.connState < CONN_STATE_CONNECTED) {
            this.wait();
        }
    }

    public synchronized void dispatchCmEvent(RdmaCmEvent cmEvent) throws IOException {
        try {
            int eventType = cmEvent.getEvent();
            if (eventType == RdmaCmEvent.EventType.RDMA_CM_EVENT_ADDR_RESOLVED.ordinal()) {
                this.connState = CONN_STATE_ADDR_RESOLVED;
                this.notifyAll();
            } else if (cmEvent.getEvent() == RdmaCmEvent.EventType.RDMA_CM_EVENT_ROUTE_RESOLVED.ordinal()) {
                this.connState = CONN_STATE_ROUTE_RESOLVED;
                this.notifyAll();
            } else if (eventType == RdmaCmEvent.EventType.RDMA_CM_EVENT_ESTABLISHED.ordinal()) {
                logger.info("got event type + RDMA_CM_EVENT_ESTABLISHED, srcAddress " + this.getSrcAddr() + ", dstAddress " + this.getDstAddr());
                this.connState = CONN_STATE_CONNECTED;
                this.notifyAll();
            } else if (eventType == RdmaCmEvent.EventType.RDMA_CM_EVENT_DISCONNECTED.ordinal()) {
                logger.info("got event type + RDMA_CM_EVENT_DISCONNECTED, srcAddress " + this.getSrcAddr() + ", dstAddress " + this.getDstAddr());
                this.connState = CONN_STATE_CLOSED;
                this.notifyAll();
            } else if (eventType == RdmaCmEvent.EventType.RDMA_CM_EVENT_CONNECT_REQUEST.ordinal()) {
                logger.info("got event type + RDMA_CM_EVENT_CONNECT_REQUEST, srcAddress " + this.getSrcAddr() + ", dstAddress " + this.getDstAddr());
            } else {
                logger.info("got event type + UNKNOWN, srcAddress " + this.getSrcAddr() + ", dstAddress " + this.getDstAddr());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public final synchronized void allocateResources() throws IOException {
        if (!this.isInitialized) {
            this.pd = this.group.createProtectionDomainRaw(this);
            this.cqProcessor = this.group.createCqProviderRaw(this);
            this.qp = this.group.createQpProviderRaw(this);
            this.isInitialized = true;
            this.init();
            this.connState = CONN_STATE_RESOURCES_ALLOCATED;
            this.notifyAll();
        }
    }

    synchronized void accept() throws Exception {
        this.group.allocateResourcesRaw(this);
        while (this.connState < CONN_STATE_RESOURCES_ALLOCATED) {
            this.wait();
        }
        if (this.connState != CONN_STATE_RESOURCES_ALLOCATED) {
            throw new IOException("resources allocation failed");
        }
        RdmaConnParam connParam = this.getConnParam();
        this.idPriv.accept(connParam);
        while (this.connState < CONN_STATE_CONNECTED) {
            this.wait();
        }
    }

    public synchronized void close() throws IOException, InterruptedException {
        if (this.isClosed) {
            return;
        }
        logger.info("closing client endpoint");
        if (this.connState == CONN_STATE_CONNECTED) {
            this.idPriv.disconnect();
            this.wait(1000L);
        }
        if (this.connState >= CONN_STATE_RESOURCES_ALLOCATED) {
            this.idPriv.destroyQP();
        }
        this.idPriv.destroyId();
        this.group.unregisterClientEp(this);
        this.isClosed = true;
        logger.info("closing client done");
    }

    public synchronized boolean isConnected() {
        return this.connState == CONN_STATE_CONNECTED;
    }

    public synchronized boolean isClosed() {
        return this.connState == CONN_STATE_CLOSED;
    }

    public SocketAddress getSrcAddr() throws IOException {
        return this.idPriv.getSource();
    }

    public SocketAddress getDstAddr() throws IOException {
        return this.idPriv.getDestination();
    }

    public RdmaCqProvider getCqProvider() {
        return this.cqProcessor;
    }

    public SVCRegMr registerMemory(ByteBuffer buffer) throws IOException {
        return this.pd.regMr(buffer, this.access);
    }

    public SVCPostRecv postRecv(List<IbvRecvWR> recvList) throws IOException {
        return this.qp.postRecv(recvList, null);
    }

    public SVCPostSend postSend(List<IbvSendWR> sendList) throws IOException {
        return this.qp.postSend(sendList, null);
    }

    public void deregisterMemory(IbvMr mr) throws IOException {
        ((SVCDeregMr)mr.deregMr().execute()).free();
    }

    public RdmaCmId getIdPriv() {
        return this.idPriv;
    }

    public IbvQP getQp() {
        return this.qp;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public int getEndpointId() {
        return this.endpointId;
    }

    public IbvPd getPd() {
        return this.pd;
    }

    protected synchronized void init() throws IOException {
    }

    public int getConnState() {
        return this.connState;
    }

    public RdmaConnParam getConnParam() {
        return this.group.getConnParam();
    }
}

