/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvCompChannel;
import com.ibm.disni.verbs.IbvContext;
import java.io.IOException;
import org.slf4j.Logger;

public class RdmaCqProvider {
    private static final Logger logger = DiSNILogger.getLogger();
    protected IbvContext context;
    protected IbvCompChannel compChannel;
    protected IbvCQ cq;
    protected int cqSize;

    public RdmaCqProvider(IbvContext context, int cqSize) throws IOException {
        logger.info("new endpoint CQ processor");
        this.context = context;
        this.compChannel = context.createCompChannel();
        this.cqSize = cqSize;
        this.cq = context.createCQ(this.compChannel, cqSize, 0);
    }

    public void close() throws IOException, InterruptedException {
        logger.info("shutting cq provider, destroying cq1");
        this.compChannel.destroyCompChannel();
        logger.info("compChannel destroyed");
        this.cq.destroyCQ();
        logger.info("cq destroyed");
    }

    public IbvCQ getCQ() {
        return this.cq;
    }

    public int getCqSize() {
        return this.cqSize;
    }
}

