/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.RdmaCqProvider;
import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.util.NativeAffinity;
import com.ibm.disni.verbs.IbvContext;
import com.ibm.disni.verbs.IbvWC;
import com.ibm.disni.verbs.SVCPollCq;
import com.ibm.disni.verbs.SVCReqNotify;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public abstract class RdmaCqProcessor<C extends RdmaEndpoint>
extends RdmaCqProvider
implements Runnable {
    private static final Logger logger = DiSNILogger.getLogger();
    private static int MAX_ACK_COUNT = 1;
    private IbvWC[] wcList;
    private SVCReqNotify reqNotify;
    private SVCPollCq poll;
    private int timeout;
    private int ackCounter;
    private boolean blocking;
    private boolean running;
    private long affinity;
    private int clusterId;
    private Thread thread;
    private int wrSize;
    private ConcurrentHashMap<Integer, C> qpMap;

    public RdmaCqProcessor(IbvContext context, int cqSize, int wrSize, long affinity, int clusterId, int timeout, boolean polling) throws IOException {
        super(context, cqSize);
        this.clusterId = clusterId;
        this.affinity = affinity;
        this.running = false;
        this.wrSize = Math.min(cqSize, wrSize);
        this.wcList = new IbvWC[this.wrSize];
        for (int i = 0; i < this.wcList.length; ++i) {
            this.wcList[i] = new IbvWC();
        }
        this.blocking = !polling;
        this.ackCounter = 0;
        this.reqNotify = this.cq.reqNotification(false);
        this.poll = this.cq.poll(this.wcList, this.wcList.length);
        this.timeout = timeout;
        if (this.blocking) {
            this.reqNotify.execute();
        }
        this.qpMap = new ConcurrentHashMap();
        this.thread = new Thread(this);
    }

    public synchronized void registerQP(int qpnum, C endpoint) throws IOException {
        this.qpMap.put(qpnum, endpoint);
    }

    public synchronized void unregister(RdmaEndpoint endpoint) throws IOException {
        logger.info("unregister ep with cq processor");
        if (this.qpMap.containsKey(endpoint.getQp().getQp_num())) {
            this.qpMap.remove(endpoint.getQp().getQp_num());
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void start() {
        this.running = true;
        this.thread.start();
    }

    public final void dispatchCqEvent(IbvWC wc) throws IOException {
        Integer qpNum = wc.getQp_num();
        RdmaEndpoint clientEndpoint = (RdmaEndpoint)this.qpMap.get(qpNum);
        if (clientEndpoint != null) {
            this.dispatchCqEvent(clientEndpoint, wc);
        }
    }

    public abstract void dispatchCqEvent(C var1, IbvWC var2) throws IOException;

    @Override
    public void run() {
        NativeAffinity.setAffinity(this.affinity);
        logger.info("running cq processing, index " + this.clusterId + ", affinity " + this.affinity + ", blocking " + this.blocking);
        this.running = true;
        while (this.running) {
            try {
                boolean success = true;
                if (this.blocking && (success = this.compChannel.getCqEvent(this.cq, this.timeout))) {
                    ++this.ackCounter;
                    if (this.ackCounter == MAX_ACK_COUNT) {
                        this.cq.ackEvents(this.ackCounter);
                        this.ackCounter = 0;
                    }
                    this.reqNotify.execute();
                }
                int res = -1;
                if (success) {
                    res = ((SVCPollCq)this.poll.execute()).getPolls();
                }
                while (res > 0) {
                    for (int i = 0; i < res; ++i) {
                        this.dispatchCqEvent(this.wcList[i]);
                    }
                    res = ((SVCPollCq)this.poll.execute()).getPolls();
                }
            }
            catch (Exception e) {
                if (this.isClosed()) {
                    logger.info("error " + e.getMessage());
                    break;
                }
                logger.info("cq processing, caught exception but keep going " + e.getMessage());
                e.printStackTrace();
            }
        }
        logger.info("terminating cq polling " + this.isClosed());
    }

    private boolean isClosed() {
        return !this.running;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public void close() throws IOException, InterruptedException {
        this.running = false;
        this.thread.join();
        super.close();
    }
}

