/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.RdmaEndpointGroup;
import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.RdmaCmEvent;
import com.ibm.disni.verbs.RdmaCmId;
import com.ibm.disni.verbs.RdmaEventChannel;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class RdmaCmProcessor
implements Runnable {
    private static final Logger logger = DiSNILogger.getLogger();
    private RdmaEventChannel cmChannel = RdmaEventChannel.createEventChannel();
    private RdmaEndpointGroup<? extends RdmaEndpoint> cmConsumer;
    private Thread thread;
    private AtomicBoolean closed;
    private int timeout;

    public RdmaCmProcessor(RdmaEndpointGroup<? extends RdmaEndpoint> cmConsumer, int timeout) throws IOException {
        if (this.cmChannel == null) {
            throw new IOException("No RDMA device configured!");
        }
        this.cmConsumer = cmConsumer;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.closed = new AtomicBoolean(true);
        this.timeout = timeout;
    }

    public synchronized void start() {
        this.closed.set(false);
        this.thread.start();
    }

    @Override
    public void run() {
        logger.info("launching cm processor, cmChannel " + this.cmChannel.getFd());
        while (!this.closed.get()) {
            try {
                RdmaCmEvent cmEvent = this.cmChannel.getCmEvent(this.timeout);
                if (cmEvent == null) continue;
                this.cmConsumer.dispatchCmEvent(cmEvent);
                cmEvent.ackEvent();
            }
            catch (Throwable e) {
                if (this.cmConsumer.isClosed()) {
                    logger.info("cm looping closes, group is shutdown!!");
                    break;
                }
                logger.info("cm processing, caught exception but keep going " + e.getMessage());
                e.printStackTrace();
            }
        }
        logger.info("terminating cm polling, closed " + this.closed);
    }

    public synchronized void close() throws IOException, InterruptedException {
        logger.info("shutting down cm processor");
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        this.thread.join();
        logger.info("cm processor down");
        this.cmChannel.destroyEventChannel();
        logger.info("cm channel down");
    }

    RdmaCmId createId(short rdmaPsTcp) throws IOException {
        RdmaCmId idPriv = this.cmChannel.createId((short)262);
        return idPriv;
    }
}

