/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.disni;

import com.ibm.disni.RdmaActiveCqProcessor;
import com.ibm.disni.RdmaActiveEndpoint;
import com.ibm.disni.RdmaCqProvider;
import com.ibm.disni.RdmaEndpoint;
import com.ibm.disni.RdmaEndpointGroup;
import com.ibm.disni.util.DiSNILogger;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvContext;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.IbvQPInitAttr;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;

public class RdmaActiveEndpointGroup<C extends RdmaActiveEndpoint>
extends RdmaEndpointGroup<C> {
    private static final Logger logger = DiSNILogger.getLogger();
    private HashMap<Integer, RdmaActiveCqProcessor<C>> cqMap;
    private int timeout;
    private boolean polling;
    protected int cqSize;
    protected int maxSge;
    protected int maxWR;

    public RdmaActiveEndpointGroup(int timeout, boolean polling, int maxWR, int maxSge, int cqSize) throws IOException {
        super(timeout);
        this.timeout = timeout;
        this.polling = polling;
        this.cqMap = new HashMap();
        this.cqSize = cqSize;
        this.maxSge = maxSge;
        this.maxWR = maxWR;
        logger.info("active endpoint group, maxWR " + maxWR + ", maxSge " + maxSge + ", cqSize " + cqSize);
    }

    @Override
    public RdmaCqProvider createCqProvider(C endpoint) throws IOException {
        logger.info("setting up cq processor");
        IbvContext context = ((RdmaEndpoint)endpoint).getIdPriv().getVerbs();
        if (context != null) {
            logger.info("setting up cq processor, context found");
            RdmaActiveCqProcessor<C> cqProcessor = null;
            int key = context.getCmd_fd();
            if (!this.cqMap.containsKey(key)) {
                cqProcessor = new RdmaActiveCqProcessor(context, this.cqSize, this.maxWR, 0L, 1, this.timeout, this.polling);
                this.cqMap.put(context.getCmd_fd(), cqProcessor);
                cqProcessor.start();
            }
            cqProcessor = this.cqMap.get(context.getCmd_fd());
            return cqProcessor;
        }
        throw new IOException("setting up cq processor, no context found");
    }

    @Override
    public IbvQP createQpProvider(C endpoint) throws IOException {
        IbvContext context = ((RdmaEndpoint)endpoint).getIdPriv().getVerbs();
        RdmaActiveCqProcessor<C> cqProcessor = this.cqMap.get(context.getCmd_fd());
        IbvCQ cq = cqProcessor.getCQ();
        IbvQPInitAttr attr = new IbvQPInitAttr();
        attr.cap().setMax_recv_sge(this.maxSge);
        attr.cap().setMax_recv_wr(this.maxWR);
        attr.cap().setMax_send_sge(this.maxSge);
        attr.cap().setMax_send_wr(this.maxWR);
        attr.setQp_type((byte)2);
        attr.setRecv_cq(cq);
        attr.setSend_cq(cq);
        IbvQP qp = ((RdmaEndpoint)endpoint).getIdPriv().createQP(((RdmaEndpoint)endpoint).getPd(), attr);
        logger.info("registering endpoint with cq");
        cqProcessor.registerQP(qp.getQp_num(), endpoint);
        return qp;
    }

    @Override
    public void allocateResources(C endpoint) throws Exception {
        ((RdmaEndpoint)endpoint).allocateResources();
    }

    @Override
    public void close() throws IOException, InterruptedException {
        super.close();
        for (RdmaActiveCqProcessor<C> cqProcessor : this.cqMap.values()) {
            cqProcessor.close();
        }
    }

    void close(RdmaEndpoint endpoint) throws IOException {
        IbvContext context = endpoint.getIdPriv().getVerbs();
        RdmaActiveCqProcessor<C> cqProcessor = this.cqMap.get(context.getCmd_fd());
        cqProcessor.unregister(endpoint);
    }

    public int getMaxWR() {
        return this.maxWR;
    }

    public int getCqSize() {
        return this.cqSize;
    }

    public int getMaxSge() {
        return this.maxSge;
    }
}

