/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailBufferedInputStream;
import org.apache.crail.CrailBufferedOutputStream;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailInputStream;
import org.apache.crail.CrailLocationClass;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailNodeType;
import org.apache.crail.CrailOutputStream;
import org.apache.crail.CrailResult;
import org.apache.crail.CrailStorageClass;
import org.apache.crail.CrailStore;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.memory.OffHeapBuffer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientTest {
    CrailStore fs;
    final String basePath = "/test";
    ThreadLocalRandom random = ThreadLocalRandom.current();

    @Before
    public void init() throws Exception {
        CrailConfiguration conf = CrailConfiguration.createConfigurationFromFile();
        this.fs = CrailStore.newInstance((CrailConfiguration)conf);
        this.fs.create("/test", CrailNodeType.DIRECTORY, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get();
    }

    @After
    public void fini() throws Exception {
        this.fs.delete("/test", true);
    }

    @Test
    public void testCreateFile() throws Exception {
        String filename = "/test/fooCreate";
        this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get();
        ((CrailNode)this.fs.lookup(filename).get()).asFile();
    }

    @Test
    public void testDeleteFile() throws Exception {
        String filename = "/test/fooDelete";
        this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get();
        this.fs.delete(filename, false).get();
        Assert.assertNull((Object)this.fs.lookup(filename).get());
    }

    @Test
    public void testRenameFile() throws Exception {
        String srcname = "/test/fooRename";
        this.fs.create(srcname, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get();
        String dstname = "/test/barRename";
        this.fs.rename(srcname, dstname).get();
        Assert.assertNull((Object)this.fs.lookup(srcname).get());
        ((CrailNode)this.fs.lookup(dstname).get()).asFile();
    }

    @Test
    public void testlookupDirectory() throws Exception {
        ((CrailNode)this.fs.lookup("/test").get()).asDirectory();
    }

    @Test
    public void testCreateDirectory() throws Exception {
        String filename = "/test/fooDir";
        this.fs.create(filename, CrailNodeType.DIRECTORY, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get();
        ((CrailNode)this.fs.lookup(filename).get()).asDirectory();
    }

    void fillRandom(ByteBuffer buffer) {
        int position = buffer.position();
        byte[] byteBuffer = new byte[buffer.remaining()];
        this.random.nextBytes(byteBuffer);
        buffer.put(byteBuffer);
        buffer.position(position);
    }

    void skipToPosition(CrailOutputStream outputStream, int position) throws Exception {
        int toWrite = position - (int)outputStream.position();
        Assert.assertTrue((toWrite >= 0 ? 1 : 0) != 0);
        if (toWrite != 0) {
            OffHeapBuffer outputBuffer = OffHeapBuffer.wrap((ByteBuffer)ByteBuffer.allocateDirect(toWrite));
            outputBuffer.limit(toWrite);
            this.fillRandom(outputBuffer.getByteBuffer());
            CrailResult result = (CrailResult)outputStream.write((CrailBuffer)outputBuffer).get();
            Assert.assertEquals((long)toWrite, (long)result.getLen());
            Assert.assertEquals((long)0L, (long)outputBuffer.remaining());
            Assert.assertEquals((long)position, (long)outputStream.position());
        }
    }

    void directStream(int length, int position, int remoteOffset) throws Exception {
        OffHeapBuffer outputBuffer = OffHeapBuffer.wrap((ByteBuffer)ByteBuffer.allocateDirect(length + position));
        OffHeapBuffer inputBuffer = OffHeapBuffer.wrap((ByteBuffer)ByteBuffer.allocateDirect(outputBuffer.capacity()));
        System.err.println("DirectStream write/read with from buffer position = " + position + ", length = " + length + ", remoteOffset = " + remoteOffset);
        String filename = "/test/fooOutputStream" + length;
        CrailFile file = ((CrailNode)this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).asFile();
        CrailOutputStream outputStream = file.getDirectOutputStream(0L);
        CrailInputStream inputStream = file.getDirectInputStream(0L);
        this.skipToPosition(outputStream, remoteOffset);
        outputBuffer.position(position);
        outputBuffer.limit(outputBuffer.position() + length);
        this.fillRandom(outputBuffer.getByteBuffer());
        CrailResult result = (CrailResult)outputStream.write((CrailBuffer)outputBuffer).get();
        Assert.assertEquals((long)length, (long)result.getLen());
        Assert.assertEquals((long)0L, (long)outputBuffer.remaining());
        Assert.assertEquals((long)(remoteOffset + length), (long)outputStream.position());
        if (inputStream.position() != (long)remoteOffset) {
            inputStream.seek((long)remoteOffset);
            Assert.assertEquals((long)remoteOffset, (long)inputStream.position());
        }
        inputBuffer.position(position);
        inputBuffer.limit(inputBuffer.position() + length);
        this.fillRandom(inputBuffer.getByteBuffer());
        result = (CrailResult)inputStream.read((CrailBuffer)inputBuffer).get();
        Assert.assertEquals((long)length, (long)result.getLen());
        Assert.assertEquals((long)0L, (long)inputBuffer.remaining());
        outputBuffer.position(position);
        inputBuffer.position(position);
        try {
            Assert.assertTrue((inputBuffer.getByteBuffer().compareTo(outputBuffer.getByteBuffer()) == 0 ? 1 : 0) != 0);
        }
        catch (AssertionError e) {
            System.err.println("outputBuffer = " + outputBuffer + ", inputBuffer = " + inputBuffer);
            System.err.println("outputStream.position() = " + outputStream.position() + ", inputStream.position() = " + inputStream.position());
            if (outputBuffer.remaining() == inputBuffer.remaining()) {
                int i = 0;
                while (outputBuffer.remaining() > 0) {
                    byte b;
                    byte a = outputBuffer.getByteBuffer().get();
                    if (a != (b = inputBuffer.getByteBuffer().get())) {
                        System.err.println("outputBuffer[" + i + "] = " + Integer.toHexString(a) + " != inputBuffer[" + i + "] = " + Integer.toHexString(b));
                        break;
                    }
                    ++i;
                }
            }
            throw e;
        }
        this.fs.delete(filename, false);
    }

    @Test
    public void testDirectStream() throws Exception {
        int[] lengths = new int[]{(int)CrailConstants.BLOCK_SIZE, (int)CrailConstants.BLOCK_SIZE * 8, this.random.nextInt((int)CrailConstants.BLOCK_SIZE - 1) + 1, this.random.nextInt((int)CrailConstants.BLOCK_SIZE * 8 - 1) + 1};
        int[] positions = new int[]{0, this.random.nextInt((int)CrailConstants.BLOCK_SIZE - 1) + 1};
        int[] remoteOffsets = new int[]{0, this.random.nextInt((int)CrailConstants.BLOCK_SIZE - 1) + 1, this.random.nextInt((int)CrailConstants.BLOCK_SIZE) + (int)CrailConstants.BLOCK_SIZE + 1};
        for (int length : lengths) {
            for (int position : positions) {
                for (int remoteOffset : remoteOffsets) {
                    this.directStream(length, position, remoteOffset);
                }
            }
        }
    }

    @Test
    public void unalignedBufferStreamSimple() throws Exception {
        System.err.println("BufferedStream unaligned write after purge");
        String filename = "/test/fooOutputStream";
        CrailFile file = ((CrailNode)this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).asFile();
        int totalBytesWritten = 0;
        int iterations = 4;
        ByteBuffer[] buffers = new ByteBuffer[iterations];
        buffers[0] = StandardCharsets.UTF_8.encode("Hello");
        buffers[1] = StandardCharsets.UTF_8.encode("World");
        buffers[2] = StandardCharsets.UTF_8.encode("Problem");
        buffers[3] = StandardCharsets.UTF_8.encode("Solved");
        for (int i = 0; i < iterations; ++i) {
            totalBytesWritten += buffers[i].capacity();
            CrailBufferedOutputStream outputStream = file.getBufferedOutputStream(0L);
            outputStream.write(buffers[i]);
            outputStream.purge().get();
            outputStream.close();
        }
        CrailBufferedInputStream inputStream = file.getBufferedInputStream(0L);
        ByteBuffer buffer = ByteBuffer.allocateDirect(totalBytesWritten);
        int read = inputStream.read(buffer);
        Assert.assertEquals((long)totalBytesWritten, (long)read);
        buffer.clear();
        Assert.assertEquals((Object)"HelloWorldProblemSolved", (Object)StandardCharsets.UTF_8.decode(buffer).toString());
    }

    @Test
    public void unalignedBufferStream() throws Exception {
        System.err.println("BufferedStream unaligned write after purge");
        String filename = "/test/fooOutputStream2";
        CrailFile file = ((CrailNode)this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).asFile();
        int totalBytesWritten = 0;
        int iterations = 10;
        ByteBuffer[] buffers = new ByteBuffer[iterations];
        for (int i = 0; i < iterations; ++i) {
            int unalignedSize;
            while ((unalignedSize = this.random.nextInt(1, CrailConstants.BUFFER_SIZE)) % CrailConstants.SLICE_SIZE == 0) {
            }
            buffers[i] = ByteBuffer.allocateDirect(unalignedSize);
            this.fillRandom(buffers[i]);
            totalBytesWritten += buffers[i].capacity();
            buffers[i].clear();
            CrailBufferedOutputStream outputStream = file.getBufferedOutputStream(0L);
            outputStream.write(buffers[i]);
            outputStream.purge().get();
            outputStream.close();
        }
        CrailBufferedInputStream inputStream = file.getBufferedInputStream(0L);
        ByteBuffer buffer = ByteBuffer.allocateDirect(totalBytesWritten);
        int read = inputStream.read(buffer);
        Assert.assertEquals((long)totalBytesWritten, (long)read);
        buffer.clear();
        for (ByteBuffer b : buffers) {
            b.clear();
            buffer.limit(buffer.position() + b.capacity());
            System.err.println("orgBuffer.capacity() = " + b.capacity());
            int i = 0;
            while (buffer.remaining() > 0) {
                byte y;
                byte x = buffer.get();
                if (x != (y = b.get())) {
                    System.err.println("buffer[" + (buffer.position() - 1) + "] = " + Integer.toHexString(x) + " != orgBuffer[" + i + "] = " + Integer.toHexString(y));
                    Assert.assertTrue((boolean)false);
                }
                ++i;
            }
        }
    }

    @Test
    public void alignBufferStreamPosition() throws Exception {
        System.err.println("BufferedStream test align position");
        String filename = "/test/fooOutputStream3";
        CrailFile file = ((CrailNode)this.fs.create(filename, CrailNodeType.DATAFILE, CrailStorageClass.DEFAULT, CrailLocationClass.DEFAULT, true).get()).asFile();
        this.fs.getStatistics().reset();
        CrailBufferedOutputStream outputStream = file.getBufferedOutputStream(0L);
        ByteBuffer beginBuffer = ByteBuffer.allocateDirect(this.random.nextInt(1, CrailConstants.SLICE_SIZE));
        this.fillRandom(beginBuffer);
        outputStream.write(beginBuffer);
        Assert.assertEquals((long)0L, (long)outputStream.outputStream().position());
        outputStream.purge().get();
        Assert.assertEquals((long)beginBuffer.capacity(), (long)outputStream.outputStream().position());
        outputStream.close();
        ByteBuffer middleBuffer = ByteBuffer.allocateDirect(CrailConstants.SLICE_SIZE);
        this.fillRandom(middleBuffer);
        outputStream = file.getBufferedOutputStream(0L);
        outputStream.write(middleBuffer);
        Assert.assertEquals((long)CrailConstants.SLICE_SIZE, (long)outputStream.outputStream().position());
        ByteBuffer endBuffer = ByteBuffer.allocateDirect(CrailConstants.SLICE_SIZE);
        this.fillRandom(endBuffer);
        outputStream.write(endBuffer);
        Assert.assertEquals((long)(CrailConstants.SLICE_SIZE * 2), (long)outputStream.outputStream().position());
        outputStream.purge().get();
        int totalSize = beginBuffer.capacity() + middleBuffer.capacity() + endBuffer.capacity();
        Assert.assertEquals((long)totalSize, (long)outputStream.outputStream().position());
        outputStream.close();
        CrailBufferedInputStream inputStream = file.getBufferedInputStream(0L);
        ByteBuffer buffer = ByteBuffer.allocateDirect(totalSize);
        inputStream.read(buffer);
        buffer.position(0);
        buffer.limit(beginBuffer.capacity());
        beginBuffer.clear();
        Assert.assertEquals((Object)beginBuffer, (Object)buffer);
        buffer.position(buffer.limit());
        buffer.limit(buffer.position() + middleBuffer.capacity());
        middleBuffer.clear();
        Assert.assertEquals((Object)middleBuffer, (Object)buffer);
        buffer.position(buffer.limit());
        buffer.limit(buffer.position() + endBuffer.capacity());
        endBuffer.clear();
        Assert.assertEquals((Object)endBuffer, (Object)buffer);
    }
}

