/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCClientEndpoint;
import com.ibm.darpc.DaRPCFuture;
import com.ibm.darpc.DaRPCMessage;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaRPCStream<R extends DaRPCMessage, T extends DaRPCMessage> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    private DaRPCClientEndpoint<R, T> endpoint;
    private LinkedBlockingDeque<DaRPCFuture<R, T>> completedList;

    DaRPCStream(DaRPCClientEndpoint<R, T> endpoint, int streamId) throws IOException {
        logger.info("new direct rpc stream");
        this.endpoint = endpoint;
        this.completedList = new LinkedBlockingDeque();
    }

    public DaRPCFuture<R, T> request(R request, T response, boolean streamLogged) throws IOException {
        DaRPCFuture<R, T> future = new DaRPCFuture<R, T>(this, this.endpoint, request, response, streamLogged);
        this.endpoint.sendRequest(future);
        return future;
    }

    public DaRPCFuture<R, T> take() throws IOException {
        try {
            DaRPCFuture<R, T> future = this.completedList.poll();
            while (future == null) {
                this.endpoint.pollOnce();
                future = this.completedList.poll();
            }
            return future;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public DaRPCFuture<R, T> take(int timeout) throws IOException {
        try {
            DaRPCFuture<R, T> future = this.completedList.poll();
            long sumtime = 0L;
            while (future == null && sumtime < (long)timeout) {
                this.endpoint.pollOnce();
                future = this.completedList.poll();
            }
            return future;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public DaRPCFuture<R, T> poll() throws IOException {
        DaRPCFuture<R, T> future = this.completedList.poll();
        if (future == null) {
            this.endpoint.pollOnce();
            future = this.completedList.poll();
        }
        return future;
    }

    public void clear() {
        this.completedList.clear();
    }

    void addFuture(DaRPCFuture<R, T> future) {
        this.completedList.add(future);
    }

    public boolean isEmpty() {
        return this.completedList.isEmpty();
    }
}

