/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCCluster;
import com.ibm.darpc.DaRPCEndpointGroup;
import com.ibm.darpc.DaRPCInstance;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.darpc.DaRPCResourceManager;
import com.ibm.darpc.DaRPCServerEndpoint;
import com.ibm.darpc.DaRPCServerEvent;
import com.ibm.darpc.DaRPCService;
import com.ibm.disni.RdmaCqProvider;
import com.ibm.disni.RdmaEndpointFactory;
import com.ibm.disni.verbs.IbvCQ;
import com.ibm.disni.verbs.IbvContext;
import com.ibm.disni.verbs.IbvQP;
import com.ibm.disni.verbs.RdmaCmId;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaRPCServerGroup<R extends DaRPCMessage, T extends DaRPCMessage>
extends DaRPCEndpointGroup<DaRPCServerEndpoint<R, T>, R, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    private ConcurrentHashMap<Integer, DaRPCInstance<R, T>> deviceInstance;
    private DaRPCResourceManager resourceManager;
    private long[] computeAffinities;
    private long[] resourceAffinities;
    private int currentCluster;
    private int nbrOfClusters;
    private DaRPCService<R, T> rpcService;
    private boolean polling;
    private int pollSize;
    private int clusterSize;

    public static <R extends DaRPCMessage, T extends DaRPCMessage> DaRPCServerGroup<R, T> createServerGroup(DaRPCService<R, T> rpcService, long[] clusterAffinities, int timeout, int maxinline, boolean polling, int recvQueue, int sendQueue, int pollSize, int clusterSize) throws Exception {
        DaRPCServerGroup<R, T> group = new DaRPCServerGroup<R, T>(rpcService, clusterAffinities, timeout, maxinline, polling, recvQueue, sendQueue, pollSize, clusterSize);
        group.init(new RpcServerFactory<R, T>(group));
        return group;
    }

    private DaRPCServerGroup(DaRPCService<R, T> rpcService, long[] clusterAffinities, int timeout, int maxinline, boolean polling, int recvQueue, int sendQueue, int pollSize, int clusterSize) throws Exception {
        super(rpcService, timeout, maxinline, recvQueue, sendQueue);
        this.rpcService = rpcService;
        this.deviceInstance = new ConcurrentHashMap();
        this.computeAffinities = clusterAffinities;
        this.resourceAffinities = clusterAffinities;
        this.nbrOfClusters = this.computeAffinities.length;
        this.currentCluster = 0;
        this.resourceManager = new DaRPCResourceManager(this.resourceAffinities, timeout);
        this.polling = polling;
        this.pollSize = pollSize;
        this.clusterSize = clusterSize;
    }

    public RdmaCqProvider createCqProvider(DaRPCServerEndpoint<R, T> endpoint) throws IOException {
        logger.info("setting up cq processor (multicore)");
        IbvContext context = endpoint.getIdPriv().getVerbs();
        if (context == null) {
            throw new IOException("setting up cq processor, no context found");
        }
        DaRPCInstance<R, T> rpcInstance = null;
        int key = context.getCmd_fd();
        if (!this.deviceInstance.containsKey(key)) {
            int cqSize = (this.recvQueueSize() + this.sendQueueSize()) * this.clusterSize;
            rpcInstance = new DaRPCInstance(context, cqSize, this.pollSize, this.computeAffinities, this.getTimeout(), this.polling);
            this.deviceInstance.put(context.getCmd_fd(), rpcInstance);
        }
        rpcInstance = this.deviceInstance.get(context.getCmd_fd());
        DaRPCCluster<R, T> cqProcessor = rpcInstance.getProcessor(endpoint.clusterId());
        return cqProcessor;
    }

    public IbvQP createQpProvider(DaRPCServerEndpoint<R, T> endpoint) throws IOException {
        logger.info("setting up QP");
        DaRPCCluster<R, T> cqProcessor = this.lookupCqProcessor(endpoint);
        IbvCQ cq = cqProcessor.getCQ();
        IbvQP qp = this.createQP(endpoint.getIdPriv(), endpoint.getPd(), cq);
        cqProcessor.registerQP(qp.getQp_num(), endpoint);
        return qp;
    }

    public void allocateResources(DaRPCServerEndpoint<R, T> endpoint) throws Exception {
        this.resourceManager.allocateResources(endpoint);
    }

    synchronized int newClusterId() {
        int newClusterId = this.currentCluster;
        this.currentCluster = (this.currentCluster + 1) % this.nbrOfClusters;
        return newClusterId;
    }

    protected synchronized DaRPCCluster<R, T> lookupCqProcessor(DaRPCServerEndpoint<R, T> endpoint) throws IOException {
        IbvContext context = endpoint.getIdPriv().getVerbs();
        if (context == null) {
            throw new IOException("setting up cq processor, no context found");
        }
        DaRPCInstance<R, T> rpcInstance = null;
        int key = context.getCmd_fd();
        if (!this.deviceInstance.containsKey(key)) {
            return null;
        }
        rpcInstance = this.deviceInstance.get(context.getCmd_fd());
        DaRPCCluster<R, T> cqProcessor = rpcInstance.getProcessor(endpoint.clusterId());
        return cqProcessor;
    }

    @Override
    public void close() throws IOException, InterruptedException {
        super.close();
        for (DaRPCInstance<R, T> rpcInstance : this.deviceInstance.values()) {
            rpcInstance.close();
        }
        this.resourceManager.close();
        logger.info("rpc group down");
    }

    public R createRequest() {
        return this.rpcService.createRequest();
    }

    public T createResponse() {
        return this.rpcService.createResponse();
    }

    public void processServerEvent(DaRPCServerEvent<R, T> event) throws IOException {
        this.rpcService.processServerEvent(event);
    }

    public void open(DaRPCServerEndpoint<R, T> endpoint) {
        this.rpcService.open(endpoint);
    }

    public void close(DaRPCServerEndpoint<R, T> endpoint) {
        this.rpcService.close(endpoint);
    }

    public DaRPCService<? extends DaRPCMessage, ? extends DaRPCMessage> getRpcService() {
        return this.rpcService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RpcServerFactory<R extends DaRPCMessage, T extends DaRPCMessage>
    implements RdmaEndpointFactory<DaRPCServerEndpoint<R, T>> {
        private DaRPCServerGroup<R, T> group;

        public RpcServerFactory(DaRPCServerGroup<R, T> group) {
            this.group = group;
        }

        public DaRPCServerEndpoint<R, T> createEndpoint(RdmaCmId id, boolean serverSide) throws IOException {
            return new DaRPCServerEndpoint<R, T>(this.group, id, serverSide);
        }
    }
}

