/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCEndpoint;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.darpc.DaRPCServerEvent;
import com.ibm.darpc.DaRPCServerGroup;
import com.ibm.disni.verbs.RdmaCmEvent;
import com.ibm.disni.verbs.RdmaCmId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaRPCServerEndpoint<R extends DaRPCMessage, T extends DaRPCMessage>
extends DaRPCEndpoint<R, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    private DaRPCServerGroup<R, T> group;
    private ArrayBlockingQueue<DaRPCServerEvent<R, T>> eventPool;
    private ArrayBlockingQueue<DaRPCServerEvent<R, T>> lazyEvents;
    private int getClusterId;

    public DaRPCServerEndpoint(DaRPCServerGroup<R, T> group, RdmaCmId idPriv, boolean serverSide) throws IOException {
        super(group, idPriv, serverSide);
        this.group = group;
        this.getClusterId = group.newClusterId();
        this.eventPool = new ArrayBlockingQueue(group.recvQueueSize());
        this.lazyEvents = new ArrayBlockingQueue(group.recvQueueSize());
    }

    @Override
    public void init() throws IOException {
        super.init();
        for (int i = 0; i < this.group.recvQueueSize(); ++i) {
            DaRPCServerEvent<R, T> event = new DaRPCServerEvent<R, T>(this, this.group.createRequest(), this.group.createResponse());
            this.eventPool.add(event);
        }
    }

    void sendResponse(DaRPCServerEvent<R, T> event) throws IOException {
        if (this.sendMessage((DaRPCMessage)event.getSendMessage(), event.getTicket())) {
            this.eventPool.add(event);
        } else {
            this.lazyEvents.add(event);
        }
    }

    public synchronized void dispatchCmEvent(RdmaCmEvent cmEvent) throws IOException {
        super.dispatchCmEvent(cmEvent);
        try {
            int eventType = cmEvent.getEvent();
            if (eventType == RdmaCmEvent.EventType.RDMA_CM_EVENT_ESTABLISHED.ordinal()) {
                logger.info("new RPC connection, eid " + this.getEndpointId());
                this.group.open(this);
            } else if (eventType == RdmaCmEvent.EventType.RDMA_CM_EVENT_DISCONNECTED.ordinal()) {
                logger.info("RPC disconnection, eid " + this.getEndpointId());
                this.group.close(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int clusterId() {
        return this.getClusterId;
    }

    @Override
    public void dispatchReceive(ByteBuffer recvBuffer, int ticket, int recvIndex) throws IOException {
        DaRPCServerEvent<R, T> event = this.eventPool.poll();
        if (event == null) {
            logger.info("no free events, must be overrunning server.. ");
            throw new IOException("no free events, must be overrunning server.. ");
        }
        event.getReceiveMessage().update(recvBuffer);
        event.stamp(ticket);
        this.postRecv(recvIndex);
        this.group.processServerEvent(event);
    }

    @Override
    public void dispatchSend(int ticket) throws IOException {
        this.freeSend(ticket);
        DaRPCServerEvent<R, T> event = this.lazyEvents.poll();
        if (event != null) {
            this.sendResponse(event);
        }
    }
}

