/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCEndpoint;
import com.ibm.darpc.DaRPCServerEndpoint;
import com.ibm.disni.util.NativeAffinity;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaRPCResourceManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    private RpcResourceAllocator[] allocaters;

    public DaRPCResourceManager(long[] affinities, int timeout) throws Exception {
        this.allocaters = new RpcResourceAllocator[affinities.length];
        for (int i = 0; i < affinities.length; ++i) {
            this.allocaters[i] = new RpcResourceAllocator(affinities[i], i, timeout);
            this.allocaters[i].start();
        }
    }

    public void allocateResources(DaRPCServerEndpoint<?, ?> endpoint) throws Exception {
        logger.info("dispatching resource, clusterid " + endpoint.clusterId());
        this.allocaters[endpoint.clusterId()].initResource(endpoint);
    }

    public void close() throws IOException, InterruptedException {
        for (int i = 0; i < this.allocaters.length; ++i) {
            this.allocaters[i].close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RpcResourceAllocator
    implements Runnable {
        private static Logger logger = LoggerFactory.getLogger((String)"com.ibm.zac.darpc");
        private LinkedBlockingQueue<DaRPCEndpoint<?, ?>> requestQueue;
        private long affinity;
        private int index;
        private boolean running;
        private Thread thread;
        private int timeout;

        public RpcResourceAllocator(long affinity, int index, int timeout) throws Exception {
            this.affinity = affinity;
            this.index = index;
            this.requestQueue = new LinkedBlockingQueue();
            this.running = false;
            this.timeout = timeout;
            if (timeout <= 0) {
                this.timeout = Integer.MAX_VALUE;
            }
            this.thread = new Thread(this);
        }

        public void initResource(DaRPCEndpoint<?, ?> endpoint) {
            this.requestQueue.add(endpoint);
        }

        public synchronized void start() {
            this.running = true;
            this.thread.start();
        }

        @Override
        public void run() {
            NativeAffinity.setAffinity((long)this.affinity);
            logger.info("running resource management, index " + this.index + ", affinity " + this.affinity + ", timeout " + this.timeout);
            while (this.running) {
                try {
                    DaRPCEndpoint<?, ?> endpoint = this.requestQueue.poll(this.timeout, TimeUnit.MILLISECONDS);
                    if (endpoint == null) continue;
                    logger.info("allocating resources, cluster " + this.index + ", endpoint " + endpoint.getEndpointId());
                    endpoint.allocateResources();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void close() throws IOException, InterruptedException {
            this.running = false;
            this.thread.join();
            logger.info("resource management closed");
        }
    }
}

