/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.darpc;

import com.ibm.darpc.DaRPCCluster;
import com.ibm.darpc.DaRPCMessage;
import com.ibm.disni.verbs.IbvContext;
import com.ibm.disni.verbs.RdmaCmId;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaRPCInstance<R extends DaRPCMessage, T extends DaRPCMessage> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.ibm.darpc");
    private DaRPCCluster<R, T>[] processorArray;
    protected ConcurrentHashMap<RdmaCmId, Object> ids;
    private int poolsize;

    public DaRPCInstance(IbvContext context, int cqSize, int wrSize, long[] affinities, int timeout, boolean polling) throws IOException {
        this.poolsize = affinities.length;
        logger.info("new cq pool, size " + this.poolsize);
        this.processorArray = new DaRPCCluster[affinities.length];
        for (int i = 0; i < affinities.length; ++i) {
            this.processorArray[i] = new DaRPCCluster(context, cqSize, wrSize, affinities[i], i, timeout, polling);
            this.processorArray[i].start();
        }
        this.ids = new ConcurrentHashMap();
    }

    public DaRPCCluster<R, T> getProcessor(int clusterId) {
        return this.processorArray[clusterId];
    }

    public void close() throws IOException, InterruptedException {
        for (int i = 0; i < this.processorArray.length; ++i) {
            this.processorArray[i].close();
        }
    }
}

